/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.executor.resultset.FastResultSetHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;

public class NestedResultSetHandler
extends FastResultSetHandler {
    private final Map<CacheKey, Object> objectCache = new HashMap<CacheKey, Object>();
    private final Map<CacheKey, Object> ancestorCache = new HashMap<CacheKey, Object>();

    public NestedResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        super(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
        if (this.configuration.isSafeRowBoundsEnabled()) {
            this.ensureNoRowBounds(rowBounds);
        }
    }

    private void ensureNoRowBounds(RowBounds rowBounds) {
        if (rowBounds != null && (rowBounds.getLimit() < Integer.MAX_VALUE || rowBounds.getOffset() > 0)) {
            throw new ExecutorException("Mapped Statements with nested result mappings cannot be safely constrained by RowBounds. Use safeRowBoundsEnabled=false setting to bypass this check.");
        }
    }

    @Override
    protected void cleanUpAfterHandlingResultSet() {
        super.cleanUpAfterHandlingResultSet();
        this.objectCache.clear();
    }

    @Override
    protected void handleRowValues(ResultSet rs, ResultMap resultMap, ResultHandler resultHandler, RowBounds rowBounds, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        DefaultResultContext resultContext = new DefaultResultContext();
        this.skipRows(rs, rowBounds);
        Object rowValue = null;
        while (this.shouldProcessMoreRows(rs, resultContext, rowBounds)) {
            ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(rs, resultMap, null);
            CacheKey rowKey = this.createRowKey(discriminatedResultMap, rs, null, resultColumnCache);
            Object partialObject = this.objectCache.get(rowKey);
            if (partialObject == null && rowValue != null) {
                if (this.mappedStatement.isResultOrdered()) {
                    this.objectCache.clear();
                }
                this.callResultHandler(resultHandler, resultContext, rowValue);
            }
            rowValue = this.getRowValue(rs, discriminatedResultMap, rowKey, rowKey, null, resultColumnCache, partialObject);
        }
        if (rowValue != null) {
            this.callResultHandler(resultHandler, resultContext, rowValue);
        }
    }

    protected Object getRowValue(ResultSet rs, ResultMap resultMap, CacheKey combinedKey, CacheKey absoluteKey, String columnPrefix, FastResultSetHandler.ResultColumnCache resultColumnCache, Object partialObject) throws SQLException {
        Object resultObject = partialObject;
        if (resultObject != null) {
            MetaObject metaObject = this.configuration.newMetaObject(resultObject);
            this.ancestorCache.put(absoluteKey, resultObject);
            this.applyNestedResultMappings(rs, resultMap, metaObject, columnPrefix, resultColumnCache, combinedKey, false);
            this.ancestorCache.remove(absoluteKey);
        } else {
            ResultLoaderMap lazyLoader = this.instantiateResultLoaderMap();
            resultObject = this.createResultObject(rs, resultMap, lazyLoader, columnPrefix, resultColumnCache);
            if (resultObject != null && !this.typeHandlerRegistry.hasTypeHandler(resultMap.getType())) {
                List<String> mappedColumnNames;
                boolean foundValues;
                MetaObject metaObject = this.configuration.newMetaObject(resultObject);
                boolean bl = foundValues = resultMap.getConstructorResultMappings().size() > 0;
                if (this.shouldApplyAutomaticMappings(resultMap, AutoMappingBehavior.FULL.equals((Object)this.configuration.getAutoMappingBehavior()))) {
                    List<String> unmappedColumnNames = resultColumnCache.getUnmappedColumnNames(resultMap, columnPrefix);
                    foundValues = this.applyAutomaticMappings(rs, unmappedColumnNames, metaObject, columnPrefix, resultColumnCache) || foundValues;
                }
                foundValues = this.applyPropertyMappings(rs, resultMap, mappedColumnNames = resultColumnCache.getMappedColumnNames(resultMap, columnPrefix), metaObject, lazyLoader, columnPrefix) || foundValues;
                this.ancestorCache.put(absoluteKey, resultObject);
                foundValues = this.applyNestedResultMappings(rs, resultMap, metaObject, columnPrefix, resultColumnCache, combinedKey, true) || foundValues;
                this.ancestorCache.remove(absoluteKey);
                foundValues = lazyLoader != null && lazyLoader.size() > 0 || foundValues;
                Object object = resultObject = foundValues ? resultObject : null;
            }
            if (combinedKey != CacheKey.NULL_CACHE_KEY) {
                this.objectCache.put(combinedKey, resultObject);
            }
        }
        return resultObject;
    }

    private boolean applyNestedResultMappings(ResultSet rs, ResultMap resultMap, MetaObject metaObject, String parentPrefix, FastResultSetHandler.ResultColumnCache resultColumnCache, CacheKey parentRowKey, boolean newObject) {
        boolean foundValues = false;
        for (ResultMapping resultMapping : resultMap.getPropertyResultMappings()) {
            String nestedResultMapId = resultMapping.getNestedResultMapId();
            if (nestedResultMapId == null) continue;
            try {
                String columnPrefix = this.getColumnPrefix(parentPrefix, resultMapping);
                ResultMap nestedResultMap = this.getNestedResultMap(rs, nestedResultMapId, columnPrefix);
                CacheKey rowKey = this.createRowKey(nestedResultMap, rs, columnPrefix, resultColumnCache);
                Object ancestorObject = this.ancestorCache.get(rowKey);
                if (ancestorObject != null) {
                    if (!newObject) continue;
                    metaObject.setValue(resultMapping.getProperty(), ancestorObject);
                    continue;
                }
                CacheKey combinedKey = this.combineKeys(rowKey, parentRowKey);
                Object rowValue = this.objectCache.get(combinedKey);
                boolean knownValue = rowValue != null;
                Object collectionProperty = this.instantiateCollectionPropertyIfAppropriate(resultMapping, metaObject);
                if (!this.anyNotNullColumnHasValue(resultMapping, columnPrefix, rs) || (rowValue = this.getRowValue(rs, nestedResultMap, combinedKey, rowKey, columnPrefix, resultColumnCache, rowValue)) == null || knownValue) continue;
                if (collectionProperty != null) {
                    MetaObject targetMetaObject = this.configuration.newMetaObject(collectionProperty);
                    targetMetaObject.add(rowValue);
                } else {
                    metaObject.setValue(resultMapping.getProperty(), rowValue);
                }
                foundValues = true;
            }
            catch (SQLException e) {
                throw new ExecutorException("Error getting nested result map values for '" + resultMapping.getProperty() + "'.  Cause: " + e, e);
            }
        }
        return foundValues;
    }

    private String getColumnPrefix(String parentPrefix, ResultMapping resultMapping) {
        StringBuilder columnPrefixBuilder = new StringBuilder();
        if (parentPrefix != null) {
            columnPrefixBuilder.append(parentPrefix);
        }
        if (resultMapping.getColumnPrefix() != null) {
            columnPrefixBuilder.append(resultMapping.getColumnPrefix());
        }
        String columnPrefix = columnPrefixBuilder.length() == 0 ? null : columnPrefixBuilder.toString().toUpperCase(Locale.ENGLISH);
        return columnPrefix;
    }

    private boolean anyNotNullColumnHasValue(ResultMapping resultMapping, String columnPrefix, ResultSet rs) throws SQLException {
        Set<String> notNullColumns = resultMapping.getNotNullColumns();
        boolean anyNotNullColumnHasValue = true;
        if (notNullColumns != null && !notNullColumns.isEmpty()) {
            anyNotNullColumnHasValue = false;
            for (String column : notNullColumns) {
                rs.getObject(NestedResultSetHandler.prependPrefix(column, columnPrefix));
                if (rs.wasNull()) continue;
                anyNotNullColumnHasValue = true;
                break;
            }
        }
        return anyNotNullColumnHasValue;
    }

    private Object instantiateCollectionPropertyIfAppropriate(ResultMapping resultMapping, MetaObject metaObject) {
        block6: {
            String propertyName = resultMapping.getProperty();
            Object propertyValue = metaObject.getValue(propertyName);
            if (propertyValue == null) {
                Class<?> type = resultMapping.getJavaType();
                if (type == null) {
                    type = metaObject.getSetterType(propertyName);
                }
                try {
                    if (this.objectFactory.isCollection(type)) {
                        propertyValue = this.objectFactory.create(type);
                        metaObject.setValue(propertyName, propertyValue);
                        return propertyValue;
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw new ExecutorException("Error instantiating collection property for result '" + resultMapping.getProperty() + "'.  Cause: " + e, e);
                }
            }
            if (this.objectFactory.isCollection(propertyValue.getClass())) {
                return propertyValue;
            }
        }
        return null;
    }

    private ResultMap getNestedResultMap(ResultSet rs, String nestedResultMapId, String columnPrefix) throws SQLException {
        ResultMap nestedResultMap = this.configuration.getResultMap(nestedResultMapId);
        nestedResultMap = this.resolveDiscriminatedResultMap(rs, nestedResultMap, columnPrefix);
        return nestedResultMap;
    }

    private CacheKey createRowKey(ResultMap resultMap, ResultSet rs, String columnPrefix, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        CacheKey cacheKey = new CacheKey();
        cacheKey.update(resultMap.getId());
        List<ResultMapping> resultMappings = this.getResultMappingsForRowKey(resultMap);
        if (resultMappings.size() == 0) {
            if (Map.class.isAssignableFrom(resultMap.getType())) {
                this.createRowKeyForMap(rs, cacheKey, resultColumnCache);
            } else {
                this.createRowKeyForUnmappedProperties(resultMap, rs, cacheKey, columnPrefix, resultColumnCache);
            }
        } else {
            this.createRowKeyForMappedProperties(resultMap, rs, cacheKey, resultMappings, columnPrefix, resultColumnCache);
        }
        return cacheKey;
    }

    private CacheKey combineKeys(CacheKey rowKey, CacheKey parentRowKey) {
        if (rowKey.getUpdateCount() > 1 && parentRowKey.getUpdateCount() > 1) {
            CacheKey combinedKey;
            try {
                combinedKey = rowKey.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new ExecutorException("Error cloning cache key.  Cause: " + e, e);
            }
            combinedKey.update(parentRowKey);
            return combinedKey;
        }
        return CacheKey.NULL_CACHE_KEY;
    }

    private List<ResultMapping> getResultMappingsForRowKey(ResultMap resultMap) {
        List<ResultMapping> resultMappings = resultMap.getIdResultMappings();
        if (resultMappings.size() == 0) {
            resultMappings = resultMap.getPropertyResultMappings();
        }
        return resultMappings;
    }

    private void createRowKeyForMappedProperties(ResultMap resultMap, ResultSet rs, CacheKey cacheKey, List<ResultMapping> resultMappings, String columnPrefix, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        for (ResultMapping resultMapping : resultMappings) {
            Object value;
            if (resultMapping.getNestedResultMapId() != null) {
                ResultMap nestedResultMap = this.configuration.getResultMap(resultMapping.getNestedResultMapId());
                this.createRowKeyForMappedProperties(nestedResultMap, rs, cacheKey, nestedResultMap.getConstructorResultMappings(), NestedResultSetHandler.prependPrefix(resultMapping.getColumnPrefix(), columnPrefix), resultColumnCache);
                continue;
            }
            if (resultMapping.getNestedQueryId() != null) continue;
            String column = NestedResultSetHandler.prependPrefix(resultMapping.getColumn(), columnPrefix);
            TypeHandler<?> th = resultMapping.getTypeHandler();
            List<String> mappedColumnNames = resultColumnCache.getMappedColumnNames(resultMap, columnPrefix);
            if (column == null || !mappedColumnNames.contains(column.toUpperCase(Locale.ENGLISH)) || (value = th.getResult(rs, column)) == null) continue;
            cacheKey.update(column);
            cacheKey.update(value);
        }
    }

    private void createRowKeyForUnmappedProperties(ResultMap resultMap, ResultSet rs, CacheKey cacheKey, String columnPrefix, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        MetaClass metaType = MetaClass.forClass(resultMap.getType());
        List<String> unmappedColumnNames = resultColumnCache.getUnmappedColumnNames(resultMap, columnPrefix);
        Iterator<String> i$ = unmappedColumnNames.iterator();
        while (i$.hasNext()) {
            String value;
            String column;
            String property = column = i$.next();
            if (columnPrefix != null && columnPrefix.length() > 0) {
                if (!column.startsWith(columnPrefix)) continue;
                property = column.substring(columnPrefix.length());
            }
            if (metaType.findProperty(property, this.configuration.isMapUnderscoreToCamelCase()) == null || (value = rs.getString(column)) == null) continue;
            cacheKey.update(column);
            cacheKey.update(value);
        }
    }

    private void createRowKeyForMap(ResultSet rs, CacheKey cacheKey, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        List<String> columnNames = resultColumnCache.getColumnNames();
        for (String columnName : columnNames) {
            String value = rs.getString(columnName);
            if (value == null) continue;
            cacheKey.update(columnName);
            cacheKey.update(value);
        }
    }
}

