/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.logging.jdbc.BaseJdbcLogger;
import org.apache.ibatis.reflection.ExceptionUtil;

public final class ResultSetLogger
extends BaseJdbcLogger
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(ResultSet.class);
    private boolean first = true;
    private ResultSet rs;

    private ResultSetLogger(ResultSet rs, Log statementLog) {
        super(statementLog);
        this.rs = rs;
    }

    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            Object o = method.invoke((Object)this.rs, params);
            if ("next".equals(method.getName()) && ((Boolean)o).booleanValue()) {
                ResultSetMetaData rsmd = this.rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                if (this.isDebugEnabled()) {
                    if (this.first) {
                        this.first = false;
                        this.printColumnHeaders(rsmd, columnCount);
                    }
                    this.printColumnValues(columnCount);
                }
            }
            this.clearColumnInfo();
            return o;
        }
        catch (Throwable t) {
            throw ExceptionUtil.unwrapThrowable(t);
        }
    }

    private void printColumnHeaders(ResultSetMetaData rsmd, int columnCount) throws SQLException {
        StringBuilder row = new StringBuilder();
        row.append("<==    Columns: ");
        for (int i = 1; i <= columnCount; ++i) {
            String colname = rsmd.getColumnName(i);
            row.append(colname);
            if (i == columnCount) continue;
            row.append(", ");
        }
        this.debug(row.toString());
    }

    private void printColumnValues(int columnCount) throws SQLException {
        StringBuilder row = new StringBuilder();
        row.append("<==        Row: ");
        for (int i = 1; i <= columnCount; ++i) {
            String colname;
            try {
                colname = this.rs.getString(i);
            }
            catch (SQLException e) {
                colname = "<<Cannot Display>>";
            }
            row.append(colname);
            if (i == columnCount) continue;
            row.append(", ");
        }
        this.debug(row.toString());
    }

    public static ResultSet newInstance(ResultSet rs, Log statementLog) {
        ResultSetLogger handler = new ResultSetLogger(rs, statementLog);
        ClassLoader cl = ResultSet.class.getClassLoader();
        return (ResultSet)Proxy.newProxyInstance(cl, new Class[]{ResultSet.class}, (InvocationHandler)handler);
    }

    public ResultSet getRs() {
        return this.rs;
    }

    protected Log getLog() {
        return log;
    }
}

