/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;

public class SqlSessionFactoryBuilder {
    public SqlSessionFactory build(Reader reader) {
        return this.build(reader, null, null);
    }

    public SqlSessionFactory build(Reader reader, String environment) {
        return this.build(reader, environment, null);
    }

    public SqlSessionFactory build(Reader reader, Properties properties) {
        return this.build(reader, null, properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SqlSessionFactory build(Reader reader, String environment, Properties properties) {
        SqlSessionFactory sqlSessionFactory;
        try {
            try {
                XMLConfigBuilder parser = new XMLConfigBuilder(reader, environment, properties);
                sqlSessionFactory = this.build(parser.parse());
                Object var7_7 = null;
                ErrorContext.instance().reset();
            }
            catch (Exception e) {
                throw ExceptionFactory.wrapException("Error building SqlSession.", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ErrorContext.instance().reset();
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return sqlSessionFactory;
        }
        reader.close();
        return sqlSessionFactory;
    }

    public SqlSessionFactory build(InputStream inputStream) {
        return this.build(inputStream, null, null);
    }

    public SqlSessionFactory build(InputStream inputStream, String environment) {
        return this.build(inputStream, environment, null);
    }

    public SqlSessionFactory build(InputStream inputStream, Properties properties) {
        return this.build(inputStream, null, properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SqlSessionFactory build(InputStream inputStream, String environment, Properties properties) {
        SqlSessionFactory sqlSessionFactory;
        try {
            try {
                XMLConfigBuilder parser = new XMLConfigBuilder(inputStream, environment, properties);
                sqlSessionFactory = this.build(parser.parse());
                Object var7_7 = null;
                ErrorContext.instance().reset();
            }
            catch (Exception e) {
                throw ExceptionFactory.wrapException("Error building SqlSession.", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ErrorContext.instance().reset();
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return sqlSessionFactory;
        }
        inputStream.close();
        return sqlSessionFactory;
    }

    public SqlSessionFactory build(Configuration config) {
        return new DefaultSqlSessionFactory(config);
    }
}

