/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.jdbc;

import java.util.ArrayList;
import java.util.List;

public class SqlBuilder {
    private static final String AND = ") \nAND (";
    private static final String OR = ") \nOR (";
    private static final ThreadLocal<SQL> localSQL = new ThreadLocal();

    public static void BEGIN() {
        SqlBuilder.RESET();
    }

    public static void RESET() {
        localSQL.set(new SQL());
    }

    public static void UPDATE(String table) {
        SqlBuilder.sql().statementType = SQL.StatementType.UPDATE;
        SqlBuilder.sql().tables.add(table);
    }

    public static void SET(String sets) {
        SqlBuilder.sql().sets.add(sets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String SQL() {
        String string;
        try {
            string = SqlBuilder.sql().sql();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            SqlBuilder.RESET();
            throw throwable;
        }
        SqlBuilder.RESET();
        return string;
    }

    public static void INSERT_INTO(String tableName) {
        SqlBuilder.sql().statementType = SQL.StatementType.INSERT;
        SqlBuilder.sql().tables.add(tableName);
    }

    public static void VALUES(String columns, String values) {
        SqlBuilder.sql().columns.add(columns);
        SqlBuilder.sql().values.add(values);
    }

    public static void SELECT(String columns) {
        SqlBuilder.sql().statementType = SQL.StatementType.SELECT;
        SqlBuilder.sql().select.add(columns);
    }

    public static void SELECT_DISTINCT(String columns) {
        SqlBuilder.sql().distinct = true;
        SqlBuilder.SELECT(columns);
    }

    public static void DELETE_FROM(String table) {
        SqlBuilder.sql().statementType = SQL.StatementType.DELETE;
        SqlBuilder.sql().tables.add(table);
    }

    public static void FROM(String table) {
        SqlBuilder.sql().tables.add(table);
    }

    public static void JOIN(String join) {
        SqlBuilder.sql().join.add(join);
    }

    public static void INNER_JOIN(String join) {
        SqlBuilder.sql().innerJoin.add(join);
    }

    public static void LEFT_OUTER_JOIN(String join) {
        SqlBuilder.sql().leftOuterJoin.add(join);
    }

    public static void RIGHT_OUTER_JOIN(String join) {
        SqlBuilder.sql().rightOuterJoin.add(join);
    }

    public static void OUTER_JOIN(String join) {
        SqlBuilder.sql().outerJoin.add(join);
    }

    public static void WHERE(String conditions) {
        SqlBuilder.sql().where.add(conditions);
        SqlBuilder.sql().lastList = SqlBuilder.sql().where;
    }

    public static void OR() {
        SqlBuilder.sql().lastList.add(OR);
    }

    public static void AND() {
        SqlBuilder.sql().lastList.add(AND);
    }

    public static void GROUP_BY(String columns) {
        SqlBuilder.sql().groupBy.add(columns);
    }

    public static void HAVING(String conditions) {
        SqlBuilder.sql().having.add(conditions);
        SqlBuilder.sql().lastList = SqlBuilder.sql().having;
    }

    public static void ORDER_BY(String columns) {
        SqlBuilder.sql().orderBy.add(columns);
    }

    private static SQL sql() {
        SQL sql = localSQL.get();
        if (sql == null) {
            SqlBuilder.RESET();
            sql = localSQL.get();
        }
        return sql;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SQL {
        StatementType statementType;
        List<String> sets = new ArrayList<String>();
        List<String> select = new ArrayList<String>();
        List<String> tables = new ArrayList<String>();
        List<String> join = new ArrayList<String>();
        List<String> innerJoin = new ArrayList<String>();
        List<String> outerJoin = new ArrayList<String>();
        List<String> leftOuterJoin = new ArrayList<String>();
        List<String> rightOuterJoin = new ArrayList<String>();
        List<String> where = new ArrayList<String>();
        List<String> having = new ArrayList<String>();
        List<String> groupBy = new ArrayList<String>();
        List<String> orderBy = new ArrayList<String>();
        List<String> lastList = new ArrayList<String>();
        List<String> columns = new ArrayList<String>();
        List<String> values = new ArrayList<String>();
        boolean distinct;

        private SQL() {
        }

        private void sqlClause(StringBuilder builder, String keyword, List<String> parts, String open, String close, String conjunction) {
            if (!parts.isEmpty()) {
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append(keyword);
                builder.append(" ");
                builder.append(open);
                String last = "________";
                int n = parts.size();
                for (int i = 0; i < n; ++i) {
                    String part = parts.get(i);
                    if (!(i <= 0 || part.equals(SqlBuilder.AND) || part.equals(SqlBuilder.OR) || last.equals(SqlBuilder.AND) || last.equals(SqlBuilder.OR))) {
                        builder.append(conjunction);
                    }
                    builder.append(part);
                    last = part;
                }
                builder.append(close);
            }
        }

        private String selectSQL() {
            StringBuilder builder = new StringBuilder();
            if (this.distinct) {
                this.sqlClause(builder, "SELECT DISTINCT", this.select, "", "", ", ");
            } else {
                this.sqlClause(builder, "SELECT", this.select, "", "", ", ");
            }
            this.sqlClause(builder, "FROM", this.tables, "", "", ", ");
            this.sqlClause(builder, "JOIN", this.join, "", "", "\nJOIN ");
            this.sqlClause(builder, "INNER JOIN", this.innerJoin, "", "", "\nINNER JOIN ");
            this.sqlClause(builder, "OUTER JOIN", this.outerJoin, "", "", "\nOUTER JOIN ");
            this.sqlClause(builder, "LEFT OUTER JOIN", this.leftOuterJoin, "", "", "\nLEFT OUTER JOIN ");
            this.sqlClause(builder, "RIGHT OUTER JOIN", this.rightOuterJoin, "", "", "\nRIGHT OUTER JOIN ");
            this.sqlClause(builder, "WHERE", this.where, "(", ")", " AND ");
            this.sqlClause(builder, "GROUP BY", this.groupBy, "", "", ", ");
            this.sqlClause(builder, "HAVING", this.having, "(", ")", " AND ");
            this.sqlClause(builder, "ORDER BY", this.orderBy, "", "", ", ");
            return builder.toString();
        }

        private String insertSQL() {
            StringBuilder builder = new StringBuilder();
            this.sqlClause(builder, "INSERT INTO", this.tables, "", "", "");
            this.sqlClause(builder, "", this.columns, "(", ")", ", ");
            this.sqlClause(builder, "VALUES", this.values, "(", ")", ", ");
            return builder.toString();
        }

        private String deleteSQL() {
            StringBuilder builder = new StringBuilder();
            this.sqlClause(builder, "DELETE FROM", this.tables, "", "", "");
            this.sqlClause(builder, "WHERE", this.where, "(", ")", " AND ");
            return builder.toString();
        }

        private String updateSQL() {
            StringBuilder builder = new StringBuilder();
            this.sqlClause(builder, "UPDATE", this.tables, "", "", "");
            this.sqlClause(builder, "SET", this.sets, "", "", ", ");
            this.sqlClause(builder, "WHERE", this.where, "(", ")", " AND ");
            return builder.toString();
        }

        public String sql() {
            String answer;
            if (this.statementType == null) {
                return null;
            }
            switch (this.statementType) {
                case DELETE: {
                    answer = this.deleteSQL();
                    break;
                }
                case INSERT: {
                    answer = this.insertSQL();
                    break;
                }
                case SELECT: {
                    answer = this.selectSQL();
                    break;
                }
                case UPDATE: {
                    answer = this.updateSQL();
                    break;
                }
                default: {
                    answer = null;
                }
            }
            return answer;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum StatementType {
            DELETE,
            INSERT,
            SELECT,
            UPDATE;

        }
    }
}

