/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor;

import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cache.TransactionalCacheManager;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;

public class CachingExecutor
implements Executor {
    private Executor delegate;
    private TransactionalCacheManager tcm = new TransactionalCacheManager();

    public CachingExecutor(Executor delegate) {
        this.delegate = delegate;
    }

    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean forceRollback) {
        try {
            this.tcm.commit();
            Object var3_2 = null;
            this.delegate.close(forceRollback);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.delegate.close(forceRollback);
            throw throwable;
        }
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public int update(MappedStatement ms, Object parameterObject) throws SQLException {
        this.flushCacheIfRequired(ms);
        return this.delegate.update(ms, parameterObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List query(MappedStatement ms, Object parameterObject, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        Cache cache;
        if (ms != null && (cache = ms.getCache()) != null) {
            block5: {
                CacheKey key;
                block6: {
                    this.flushCacheIfRequired(ms);
                    cache.getReadWriteLock().readLock().lock();
                    try {
                        if (!ms.isUseCache() || resultHandler != null) break block5;
                        key = this.createCacheKey(ms, parameterObject, rowBounds);
                        List cachedList = (List)cache.getObject(key);
                        if (cachedList == null) break block6;
                        List list = cachedList;
                        Object var11_11 = null;
                        cache.getReadWriteLock().readLock().unlock();
                        return list;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        cache.getReadWriteLock().readLock().unlock();
                        throw throwable;
                    }
                }
                List list = this.delegate.query(ms, parameterObject, rowBounds, resultHandler);
                this.tcm.putObject(cache, key, list);
                List list2 = list;
                Object var11_12 = null;
                cache.getReadWriteLock().readLock().unlock();
                return list2;
            }
            List list = this.delegate.query(ms, parameterObject, rowBounds, resultHandler);
            Object var11_13 = null;
            cache.getReadWriteLock().readLock().unlock();
            return list;
        }
        return this.delegate.query(ms, parameterObject, rowBounds, resultHandler);
    }

    public List flushStatements() throws SQLException {
        return this.delegate.flushStatements();
    }

    public void commit(boolean required) throws SQLException {
        this.delegate.commit(required);
        this.tcm.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(boolean required) throws SQLException {
        try {
            this.delegate.rollback(required);
            Object var3_2 = null;
            if (required) {
                this.tcm.rollback();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (required) {
                this.tcm.rollback();
            }
            throw throwable;
        }
    }

    public CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return this.delegate.createCacheKey(ms, parameterObject, rowBounds);
    }

    public boolean isCached(MappedStatement ms, CacheKey key) {
        throw new UnsupportedOperationException("The CachingExecutor should not be used by result loaders and thus isCached() should never be called.");
    }

    public void deferLoad(MappedStatement ms, MetaObject resultObject, String property, CacheKey key) {
        throw new UnsupportedOperationException("The CachingExecutor should not be used by result loaders and thus deferLoad() should never be called.");
    }

    public void clearLocalCache() {
        this.delegate.clearLocalCache();
    }

    private void flushCacheIfRequired(MappedStatement ms) {
        Cache cache = ms.getCache();
        if (cache != null && ms.isFlushCacheRequired()) {
            this.tcm.clear(cache);
        }
    }
}

