/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.security;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import mousio.client.exceptions.SecurityContextException;

public final class SecurityContextBuilder {
    public static final String KEYSTORE_JKS = "JKS";

    public static SslContext forKeystore(String keystorePath, String keystorePassword) throws SecurityContextException {
        return SecurityContextBuilder.forKeystore(keystorePath, keystorePassword, "SunX509");
    }

    public static SslContext forKeystore(String keystorePath, String keystorePassword, String keyManagerAlgorithm) throws SecurityContextException {
        try {
            return SecurityContextBuilder.forKeystore(new FileInputStream(keystorePath), keystorePassword, keyManagerAlgorithm);
        }
        catch (Exception e) {
            throw new SecurityContextException(e);
        }
    }

    public static SslContext forKeystore(InputStream keystore, String keystorePassword, String keyManagerAlgorithm) throws SecurityContextException {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_JKS);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            ks.load(keystore, keystorePassword.toCharArray());
            kmf.init(ks, keystorePassword.toCharArray());
            SslContextBuilder ctxBuilder = SslContextBuilder.forClient().keyManager(kmf);
            return ctxBuilder.build();
        }
        catch (Exception e) {
            throw new SecurityContextException(e);
        }
    }

    public static SslContext forKeystoreAndTruststore(String keystorePath, String keystorePassword, String truststorePath, String truststorePassword) throws SecurityContextException {
        return SecurityContextBuilder.forKeystoreAndTruststore(keystorePath, keystorePassword, truststorePath, truststorePassword, "SunX509");
    }

    public static SslContext forKeystoreAndTruststore(String keystorePath, String keystorePassword, String truststorePath, String truststorePassword, String keyManagerAlgorithm) throws SecurityContextException {
        try {
            return SecurityContextBuilder.forKeystoreAndTruststore(new FileInputStream(keystorePath), keystorePassword, new FileInputStream(truststorePath), truststorePassword, keyManagerAlgorithm);
        }
        catch (Exception e) {
            throw new SecurityContextException(e);
        }
    }

    public static SslContext forKeystoreAndTruststore(InputStream keystore, String keystorePassword, InputStream truststore, String truststorePassword, String keyManagerAlgorithm) throws SecurityContextException {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_JKS);
            KeyStore ts = KeyStore.getInstance(KEYSTORE_JKS);
            KeyManagerFactory keystoreKmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            TrustManagerFactory truststoreKmf = TrustManagerFactory.getInstance(keyManagerAlgorithm);
            ks.load(keystore, keystorePassword.toCharArray());
            ts.load(truststore, truststorePassword.toCharArray());
            keystoreKmf.init(ks, keystorePassword.toCharArray());
            truststoreKmf.init(ts);
            SslContextBuilder ctxBuilder = SslContextBuilder.forClient().keyManager(keystoreKmf);
            ctxBuilder.trustManager(truststoreKmf);
            return ctxBuilder.build();
        }
        catch (Exception e) {
            throw new SecurityContextException(e);
        }
    }
}

