/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.ast.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.moditect.internal.shaded.javaparser.TokenRange;
import org.moditect.internal.shaded.javaparser.ast.AllFieldsConstructor;
import org.moditect.internal.shaded.javaparser.ast.Node;
import org.moditect.internal.shaded.javaparser.ast.NodeList;
import org.moditect.internal.shaded.javaparser.ast.expr.AnnotationExpr;
import org.moditect.internal.shaded.javaparser.ast.nodeTypes.NodeWithAnnotations;
import org.moditect.internal.shaded.javaparser.ast.observer.ObservableProperty;
import org.moditect.internal.shaded.javaparser.ast.type.ReferenceType;
import org.moditect.internal.shaded.javaparser.ast.type.Type;
import org.moditect.internal.shaded.javaparser.ast.visitor.CloneVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.GenericVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.VoidVisitor;
import org.moditect.internal.shaded.javaparser.metamodel.ArrayTypeMetaModel;
import org.moditect.internal.shaded.javaparser.metamodel.JavaParserMetaModel;
import org.moditect.internal.shaded.javaparser.resolution.Context;
import org.moditect.internal.shaded.javaparser.resolution.types.ResolvedArrayType;
import org.moditect.internal.shaded.javaparser.resolution.types.ResolvedType;
import org.moditect.internal.shaded.javaparser.utils.Pair;
import org.moditect.internal.shaded.javaparser.utils.Utils;

public class ArrayType
extends ReferenceType
implements NodeWithAnnotations<ArrayType> {
    private Type componentType;
    private Origin origin;

    @Override
    public ResolvedArrayType resolve() {
        return this.getSymbolResolver().toResolvedType(this, ResolvedArrayType.class);
    }

    @AllFieldsConstructor
    public ArrayType(Type componentType, Origin origin, NodeList<AnnotationExpr> annotations) {
        this(null, componentType, origin, annotations);
    }

    public ArrayType(Type type, AnnotationExpr ... annotations) {
        this(type, Origin.TYPE, NodeList.nodeList((Node[])annotations));
    }

    public ArrayType(TokenRange tokenRange, Type componentType, Origin origin, NodeList<AnnotationExpr> annotations) {
        super(tokenRange, annotations);
        this.setComponentType(componentType);
        this.setOrigin(origin);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public ArrayType setComponentType(Type componentType) {
        Utils.assertNotNull(componentType);
        if (componentType == this.componentType) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.COMPONENT_TYPE, this.componentType, componentType);
        if (this.componentType != null) {
            this.componentType.setParentNode(null);
        }
        this.componentType = componentType;
        this.setAsParentNodeOf(componentType);
        return this;
    }

    @SafeVarargs
    public static Type wrapInArrayTypes(Type type, List<ArrayBracketPair> ... arrayBracketPairLists) {
        TokenRange outerMostTokenRange = null;
        for (int i = arrayBracketPairLists.length - 1; i >= 0; --i) {
            List<ArrayBracketPair> arrayBracketPairList = arrayBracketPairLists[i];
            if (arrayBracketPairList == null) continue;
            for (int j = arrayBracketPairList.size() - 1; j >= 0; --j) {
                ArrayBracketPair pair = arrayBracketPairList.get(j);
                if (type.getTokenRange().isPresent() && pair.getTokenRange().isPresent()) {
                    TokenRange currentTokenRange = new TokenRange(type.getTokenRange().get().getBegin(), pair.getTokenRange().get().getEnd());
                    outerMostTokenRange = ArrayType.getOuterMostTokenRange(currentTokenRange, outerMostTokenRange);
                }
                type = new ArrayType(outerMostTokenRange, type, pair.getOrigin(), pair.getAnnotations());
            }
        }
        return type;
    }

    private static TokenRange getOuterMostTokenRange(TokenRange tokenRange1, TokenRange tokenRange2) {
        if (tokenRange2 == null) {
            return tokenRange1;
        }
        if (tokenRange1.getEnd().getRange().get().isAfter(tokenRange2.getEnd().getRange().get())) {
            return tokenRange1;
        }
        return new TokenRange(tokenRange1.getBegin(), tokenRange2.getEnd());
    }

    public static Pair<Type, List<ArrayBracketPair>> unwrapArrayTypes(Type type) {
        ArrayList<ArrayBracketPair> arrayBracketPairs = new ArrayList<ArrayBracketPair>(0);
        while (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            arrayBracketPairs.add(new ArrayBracketPair(type.getTokenRange().orElse(null), arrayType.getOrigin(), arrayType.getAnnotations()));
            type = arrayType.getComponentType();
        }
        return new Pair<Type, List<ArrayBracketPair>>(type, arrayBracketPairs);
    }

    @Override
    public ArrayType setAnnotations(NodeList<AnnotationExpr> annotations) {
        return (ArrayType)super.setAnnotations(annotations);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public ArrayType setOrigin(Origin origin) {
        Utils.assertNotNull(origin);
        if (origin == this.origin) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ORIGIN, this.origin, origin);
        this.origin = origin;
        return this;
    }

    @Override
    public String asString() {
        return this.componentType.asString() + "[]";
    }

    @Override
    public String toDescriptor() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.componentType.toDescriptor());
        return sb.toString();
    }

    @Override
    public ArrayType clone() {
        return (ArrayType)this.accept(new CloneVisitor(), null);
    }

    @Override
    public ArrayTypeMetaModel getMetaModel() {
        return JavaParserMetaModel.arrayTypeMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.componentType) {
            this.setComponentType((Type)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public ArrayType asArrayType() {
        return this;
    }

    @Override
    public void ifArrayType(Consumer<ArrayType> action) {
        action.accept(this);
    }

    @Override
    public Optional<ArrayType> toArrayType() {
        return Optional.of(this);
    }

    @Override
    public Type getElementType() {
        return this.getComponentType().getElementType();
    }

    @Override
    public int getArrayLevel() {
        return 1 + this.getComponentType().getArrayLevel();
    }

    @Override
    public ResolvedType convertToUsage(Context context) {
        return new ResolvedArrayType(this.getComponentType().convertToUsage(context));
    }

    public static class ArrayBracketPair {
        private TokenRange tokenRange;
        private NodeList<AnnotationExpr> annotations = new NodeList();
        private Origin origin;

        public ArrayBracketPair(TokenRange tokenRange, Origin origin, NodeList<AnnotationExpr> annotations) {
            this.setTokenRange(tokenRange);
            this.setAnnotations(annotations);
            this.setOrigin(origin);
        }

        public NodeList<AnnotationExpr> getAnnotations() {
            return this.annotations;
        }

        public ArrayBracketPair setAnnotations(NodeList<AnnotationExpr> annotations) {
            this.annotations = Utils.assertNotNull(annotations);
            return this;
        }

        public ArrayBracketPair setTokenRange(TokenRange range) {
            this.tokenRange = range;
            return this;
        }

        public Optional<TokenRange> getTokenRange() {
            return Optional.ofNullable(this.tokenRange);
        }

        public Origin getOrigin() {
            return this.origin;
        }

        public ArrayBracketPair setOrigin(Origin origin) {
            this.origin = Utils.assertNotNull(origin);
            return this;
        }
    }

    public static enum Origin {
        NAME,
        TYPE;

    }
}

