/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.moditect.spi.log.Log;

public class ProcessExecutor {
    public static void run(String name, List<String> command, Log log) {
        Process process;
        ProcessBuilder builder = new ProcessBuilder(command);
        ArrayList<String> outputLines = new ArrayList<String>();
        try {
            String line;
            process = builder.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = in.readLine()) != null) {
                outputLines.add(line);
                log.debug(line);
            }
            BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = err.readLine()) != null) {
                log.error(line);
            }
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            for (String line : outputLines) {
                log.error(line);
            }
            throw new RuntimeException("Couldn't run " + name, e);
        }
        if (process.exitValue() != 0) {
            for (String line : outputLines) {
                log.error(line);
            }
            throw new RuntimeException("Execution of " + name + " failed");
        }
    }
}

