/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.analyzer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.moditect.internal.shaded.asm.ClassReader;
import org.moditect.internal.shaded.asm.ClassVisitor;
import org.moditect.internal.shaded.asm.MethodVisitor;
import org.moditect.internal.shaded.asm.Type;
import org.moditect.spi.log.Log;

public class ServiceLoaderUseScanner {
    private final Log log;

    public ServiceLoaderUseScanner(Log log) {
        this.log = log;
    }

    public Set<String> getUsedServices(Path jar) {
        HashSet<String> usedServices = new HashSet<String>();
        try (JarFile jarFile = new JarFile(jar.toFile());){
            jarFile.stream().filter(je -> !je.isDirectory() && je.getName().endsWith(".class")).forEach(je -> usedServices.addAll(this.getUsedServices(jarFile, (JarEntry)je)));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't open or close JAR file " + jar, e);
        }
        return usedServices;
    }

    private Set<String> getUsedServices(JarFile jarFile, JarEntry je) {
        final HashSet<String> usedServices = new HashSet<String>();
        try (InputStream classFile = jarFile.getInputStream(je);){
            new ClassReader(classFile).accept(new ClassVisitor(589824){

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    return new MethodVisitor(589824){
                        private Type lastType;

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if (owner.equals("java/util/ServiceLoader") && name.equals("load")) {
                                if (this.lastType == null) {
                                    ServiceLoaderUseScanner.this.log.warn("Cannot derive uses clause from service loader invocation with non constant class literal");
                                } else {
                                    usedServices.add(this.lastType.getClassName());
                                }
                            }
                        }

                        @Override
                        public void visitLdcInsn(Object cst) {
                            if (cst instanceof Type) {
                                this.lastType = (Type)cst;
                            }
                        }
                    };
                }
            }, 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return usedServices;
    }
}

