/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.Map;
import org.modelmapper.config.Configuration;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoSetResolver;
import org.modelmapper.internal.TypeInfo;
import org.modelmapper.spi.NameableType;

class TypeInfoImpl<T>
implements TypeInfo<T> {
    private final T source;
    private final Class<T> type;
    private final InheritingConfiguration configuration;
    private volatile Map<String, Accessor> accessors;
    private volatile Map<String, Mutator> mutators;

    TypeInfoImpl(T source, Class<T> sourceType, InheritingConfiguration configuration) {
        this.source = source;
        this.type = sourceType;
        this.configuration = configuration;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeInfo)) {
            return false;
        }
        TypeInfo typeInfo = (TypeInfo)obj;
        return this.type.equals(typeInfo.getType()) && this.configuration.equals(typeInfo.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Accessor> getAccessors() {
        if (this.accessors == null) {
            TypeInfoImpl typeInfoImpl = this;
            synchronized (typeInfoImpl) {
                if (this.accessors == null) {
                    this.accessors = PropertyInfoSetResolver.resolveAccessors(this.source, this.type, this.configuration);
                }
            }
        }
        return this.accessors;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Mutator> getMutators() {
        if (this.mutators == null) {
            TypeInfoImpl typeInfoImpl = this;
            synchronized (typeInfoImpl) {
                if (this.mutators == null) {
                    this.mutators = PropertyInfoSetResolver.resolveMutators(this.type, this.configuration);
                }
            }
        }
        return this.mutators;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode() * 31 + this.configuration.hashCode();
    }

    public String toString() {
        return this.type.toString();
    }

    Mutator mutatorForAccessorMethod(String accessorMethodName) {
        return this.getMutators().get(this.configuration.getSourceNameTransformer().transform(accessorMethodName, NameableType.METHOD));
    }
}

