/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.util;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.mail.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache
extends LinkedHashMap<String, Message> {
    private static final long serialVersionUID = 4000823529559716310L;
    private static final int DEFAULT_MAX_ENTRIES = 1000;
    private static final String MAX_ENTRIES_PROPERTY = "mstor.cache.maxentries";
    private int maxEntries;

    public Cache() {
        try {
            this.maxEntries = Integer.parseInt(System.getProperty(MAX_ENTRIES_PROPERTY));
        }
        catch (Exception e) {
            this.maxEntries = 1000;
        }
    }

    public Cache(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public Cache(int initialCapacity, int maxEntries) {
        super(initialCapacity);
        this.maxEntries = maxEntries;
    }

    public Cache(int initialCapacity, float loadFactor, int maxEntries) {
        super(initialCapacity, loadFactor);
        this.maxEntries = maxEntries;
    }

    public Cache(int initialCapacity, float loadFactor, boolean accessOrder, int maxEntries) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maxEntries = maxEntries;
    }

    public Cache(Map<String, Message> m, int maxEntries) {
        super(m);
        this.maxEntries = maxEntries;
    }

    @Override
    protected final boolean removeEldestEntry(Map.Entry<String, Message> entry) {
        return this.size() > this.maxEntries;
    }
}

