/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.connector.jcr;

import java.util.List;
import javax.jcr.Session;
import javax.mail.Flags;
import net.fortuna.mstor.connector.jcr.JcrMessage;
import net.fortuna.mstor.util.MessageUtils;
import org.jcrom.Jcrom;
import org.jcrom.dao.AbstractJcrDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrMessageDao
extends AbstractJcrDAO<JcrMessage> {
    public JcrMessageDao(Session session, Jcrom jcrom) {
        super(JcrMessage.class, session, jcrom, new String[]{"mix:versionable"});
    }

    public List<JcrMessage> findByMessageNumber(String path, int messageNumber) {
        return this.updateDao(super.findByXPath("/jcr:root" + path + "/*[@messageNumber=" + messageNumber + "]", "*", -1));
    }

    public List<JcrMessage> findByMessageId(String path, String messageId) {
        return this.updateDao(super.findByXPath("/jcr:root" + path + "/*[@messageId='" + messageId + "']", "*", -1));
    }

    public List<JcrMessage> findByHeader(String path, String name, String value) {
        return this.updateDao(super.findByXPath("/jcr:root" + path + "/*/headers[@" + name + "='" + value + "']/..", "*", -1));
    }

    public List<JcrMessage> findByFlag(String path, Flags.Flag flag) {
        return this.updateDao(super.findByXPath("/jcr:root" + path + "/*[jcr:like(@flags, '" + MessageUtils.getFlagName(flag) + "')]", "*", -1));
    }

    private List<JcrMessage> updateDao(List<JcrMessage> messages) {
        for (JcrMessage message : messages) {
            message.setMessageDao(this);
        }
        return messages;
    }
}

