/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.connector.jcr;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.URLName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.fortuna.mstor.MStorFolder;
import net.fortuna.mstor.MStorStore;
import net.fortuna.mstor.connector.AbstractProtocolConnector;
import net.fortuna.mstor.connector.jcr.JcrFolder;
import net.fortuna.mstor.connector.jcr.JcrMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.rmi.client.ClientRepositoryFactory;
import org.jcrom.Jcrom;

public class JcrConnector
extends AbstractProtocolConnector {
    private Jcrom jcrom;
    private Repository repository;
    private Session session;
    private javax.mail.Session mailSession;

    public JcrConnector(URLName url, MStorStore store, javax.mail.Session session) {
        super(url, store);
        this.mailSession = session;
        this.jcrom = new Jcrom();
        this.jcrom.map(JcrFolder.class);
        this.jcrom.map(JcrMessage.class);
    }

    public boolean connect() throws AuthenticationFailedException, MessagingException {
        if (StringUtils.isEmpty((String)this.mailSession.getProperty("mstor.repository.provider.url"))) {
            try {
                InitialContext context = new InitialContext();
                this.repository = (Repository)context.lookup(this.mailSession.getProperty("mstor.repository.name"));
            }
            catch (NamingException ne) {
                throw new MessagingException("Error locating repository", (Exception)ne);
            }
        }
        try {
            ClientRepositoryFactory factory = new ClientRepositoryFactory();
            this.repository = factory.getRepository(this.mailSession.getProperty("mstor.repository.provider.url") + "/" + this.mailSession.getProperty("mstor.repository.name"));
        }
        catch (Exception e) {
            throw new MessagingException("Error locating repository", e);
        }
        PasswordAuthentication auth = this.mailSession.requestPasswordAuthentication(null, 0, "mstor", null, null);
        try {
            if (auth != null) {
                SimpleCredentials credentials = new SimpleCredentials(auth.getUserName(), auth.getPassword().toCharArray());
                this.session = this.repository.login((Credentials)credentials);
            } else {
                this.session = this.repository.login();
            }
            return true;
        }
        catch (LoginException le) {
            throw new AuthenticationFailedException("Error authenticating user: " + le.getMessage());
        }
        catch (RepositoryException re) {
            throw new MessagingException("Error authenicating user", (Exception)((Object)re));
        }
    }

    public void disconnect() throws MessagingException {
        this.session.logout();
    }

    public Folder getDefaultFolder() throws MessagingException {
        JcrFolder delegate = (JcrFolder)this.jcrom.fromNode(JcrFolder.class, this.getNode());
        delegate.setConnector(this);
        if (!delegate.exists()) {
            delegate.create(2);
        }
        return new MStorFolder(this.store, delegate);
    }

    public Folder getFolder(String name) throws MessagingException {
        return this.getDefaultFolder().getFolder(name);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        return this.getDefaultFolder().getFolder(url.getFile());
    }

    Jcrom getJcrom() {
        return this.jcrom;
    }

    Session getSession() {
        return this.session;
    }

    private void assertConnected() throws MessagingException {
        if (this.session == null) {
            throw new MessagingException("Not connected");
        }
    }

    private Node getNode() throws MessagingException {
        block10: {
            this.assertConnected();
            String path = this.mailSession.getProperty("mstor.repository.path");
            if (path != null) {
                try {
                    try {
                        return this.session.getRootNode().getNode(path);
                    }
                    catch (RepositoryException e) {
                        if (e instanceof PathNotFoundException) {
                            throw (PathNotFoundException)((Object)e);
                        }
                        throw new MessagingException("Unexpected error", (Exception)((Object)e));
                    }
                }
                catch (PathNotFoundException pnfe) {
                    if (!"true".equals(this.mailSession.getProperty("mstor.repository.create"))) break block10;
                    try {
                        this.session.getRootNode().addNode(path);
                        return this.session.getRootNode().getNode(path);
                    }
                    catch (RepositoryException e) {
                        throw new MessagingException("Unexpected error", (Exception)((Object)e));
                    }
                }
            }
        }
        try {
            return this.session.getRootNode();
        }
        catch (RepositoryException e) {
            throw new MessagingException("Unexpected error", (Exception)((Object)e));
        }
    }
}

