/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzOffsetTo;

public class TimeZone
extends java.util.TimeZone {
    private static final long serialVersionUID = -5620979316746547234L;
    private final VTimeZone vTimeZone;
    private final int rawOffset;

    public TimeZone(VTimeZone vTimeZone) {
        this.vTimeZone = vTimeZone;
        TzId tzId = (TzId)vTimeZone.getProperty("TZID");
        this.setID(tzId.getValue());
        this.rawOffset = TimeZone.getRawOffset(vTimeZone);
    }

    public final int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.set(0, era);
        cal.set(1, year);
        cal.set(2, month);
        cal.set(6, day);
        cal.set(7, dayOfWeek);
        cal.set(14, milliseconds);
        Observance observance = this.vTimeZone.getApplicableObservance(new DateTime(cal.getTime()));
        if (observance != null) {
            TzOffsetTo offset = (TzOffsetTo)observance.getProperty("TZOFFSETTO");
            return (int)offset.getOffset().getOffset();
        }
        return 0;
    }

    public final int getRawOffset() {
        return this.rawOffset;
    }

    public final boolean inDaylightTime(Date date) {
        Observance observance = this.vTimeZone.getApplicableObservance(new DateTime(date));
        return observance != null && observance instanceof Daylight;
    }

    public final void setRawOffset(int offsetMillis) {
        throw new UnsupportedOperationException("Updates to the VTIMEZONE object must be performed directly");
    }

    public final boolean useDaylightTime() {
        ComponentList daylights = this.vTimeZone.getObservances().getComponents("DAYLIGHT");
        return !daylights.isEmpty();
    }

    public final VTimeZone getVTimeZone() {
        return this.vTimeZone;
    }

    private static final int getRawOffset(VTimeZone vt) {
        ComponentList seasonalTimes = vt.getObservances().getComponents("STANDARD");
        if (seasonalTimes.size() == 0) {
            seasonalTimes = vt.getObservances().getComponents("DAYLIGHT");
        }
        if (seasonalTimes.size() > 0) {
            Collections.sort(seasonalTimes);
            Component latestSeasonalTime = (Component)seasonalTimes.get(seasonalTimes.size() - 1);
            TzOffsetTo offsetTo = (TzOffsetTo)latestSeasonalTime.getProperty("TZOFFSETTO");
            if (offsetTo != null) {
                return (int)offsetTo.getOffset().getOffset();
            }
        }
        return 0;
    }
}

