/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.util.Assert;

public class JsonUtils {
    public static String beautifyJson(Object object) {
        Assert.notNull((Object)object, (String)"The wait beautify object cannot be null.");
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Unable to format json.");
        }
    }

    public static String beautifyJson(String json) {
        Assert.notNull((Object)json, (String)"The wait beautify json string cannot be null.");
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object object = mapper.readValue(json, Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Unable to format json.");
        }
    }

    public static String toJsonString(Object object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Unable to format json.");
        }
    }

    public static <T> T fromJsonString(String json, Class<T> targetClass) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (T)mapper.readValue(json, targetClass);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Unable to format json.");
        }
    }
}

