/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class BeanUtils {
    public static void registerInfrastructureBean(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, Object ... constructorArgs) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(beanClass);
        for (Object constructorArg : constructorArgs) {
            beanDefinitionBuilder.addConstructorArgValue(constructorArg);
        }
        beanDefinitionBuilder.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    public static void registerInfrastructureBeanIfAbsent(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, Object ... constructorArgs) {
        if (!BeanUtils.isBeanDefinitionPresent(registry, beanName, beanClass) && !registry.containsBeanDefinition(beanName)) {
            BeanUtils.registerInfrastructureBean(registry, beanName, beanClass, constructorArgs);
        }
    }

    public static boolean isBeanDefinitionPresent(BeanDefinitionRegistry registry, String beanName, Class<?> targetBeanClass) {
        String[] beanNames = BeanUtils.getBeanNames((ListableBeanFactory)registry, targetBeanClass);
        return Arrays.stream(beanNames).collect(Collectors.toList()).contains(beanName);
    }

    public static String[] getBeanNames(ListableBeanFactory beanFactory, Class<?> targetBeanClass) {
        return beanFactory.getBeanNamesForType(targetBeanClass);
    }
}

