/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.mapdb.DBException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializer;

public final class SerializerCompressionDeflateWrapper<E>
implements GroupSerializer<E>,
Serializable {
    private static final long serialVersionUID = 8529699349939823553L;
    protected final GroupSerializer<E> serializer;
    protected final int compressLevel;
    protected final byte[] dictionary;

    public SerializerCompressionDeflateWrapper(GroupSerializer<E> serializer) {
        this(serializer, 0, null);
    }

    public SerializerCompressionDeflateWrapper(GroupSerializer<E> serializer, int compressLevel, byte[] dictionary) {
        this.serializer = serializer;
        this.compressLevel = compressLevel;
        this.dictionary = dictionary == null || dictionary.length == 0 ? null : dictionary;
    }

    @Override
    public void serialize(DataOutput2 out, E value) throws IOException {
        int newLen;
        DataOutput2 out2 = new DataOutput2();
        this.serializer.serialize(out2, value);
        byte[] tmp = new byte[out2.pos + 41];
        try {
            Deflater deflater = new Deflater(this.compressLevel);
            if (this.dictionary != null) {
                deflater.setDictionary(this.dictionary);
            }
            deflater.setInput(out2.buf, 0, out2.pos);
            deflater.finish();
            newLen = deflater.deflate(tmp);
        }
        catch (IndexOutOfBoundsException e) {
            newLen = 0;
        }
        if (newLen >= out2.pos || newLen == 0) {
            out.packInt(0);
            out.write(out2.buf, 0, out2.pos);
            return;
        }
        out.packInt(out2.pos + 1);
        out.write(tmp, 0, newLen);
    }

    @Override
    public E deserialize(DataInput2 in, int available) throws IOException {
        int unpackedSize = in.unpackInt() - 1;
        if (unpackedSize == -1) {
            return (E)this.serializer.deserialize(in, available > 0 ? available - 1 : available);
        }
        Inflater inflater = new Inflater();
        if (this.dictionary != null) {
            inflater.setDictionary(this.dictionary);
        }
        InflaterInputStream in4 = new InflaterInputStream(new DataInput2.DataInputToStream(in), inflater);
        byte[] unpacked = new byte[unpackedSize];
        in4.read(unpacked, 0, unpackedSize);
        DataInput2.ByteArray in2 = new DataInput2.ByteArray(unpacked);
        Object ret2 = this.serializer.deserialize(in2, unpackedSize);
        if (in2.pos != unpackedSize) {
            throw new DBException.DataCorruption("data were not fully read");
        }
        return (E)ret2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializerCompressionDeflateWrapper that = (SerializerCompressionDeflateWrapper)o;
        if (this.compressLevel != that.compressLevel) {
            return false;
        }
        if (!this.serializer.equals(that.serializer)) {
            return false;
        }
        return Arrays.equals(this.dictionary, that.dictionary);
    }

    public int hashCode() {
        int result = this.serializer.hashCode();
        result = 31 * result + this.compressLevel;
        result = 31 * result + (this.dictionary != null ? Arrays.hashCode(this.dictionary) : 0);
        return result;
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public int valueArraySearch(Object keys, E key) {
        return this.serializer.valueArraySearch(keys, key);
    }

    @Override
    public int valueArraySearch(Object keys, E key, Comparator comparator) {
        return this.serializer.valueArraySearch(keys, key, comparator);
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        int newLen;
        DataOutput2 out2 = new DataOutput2();
        this.serializer.valueArraySerialize(out2, vals);
        if (out2.pos == 0) {
            return;
        }
        byte[] tmp = new byte[out2.pos + 41];
        try {
            Deflater deflater = new Deflater(this.compressLevel);
            if (this.dictionary != null) {
                deflater.setDictionary(this.dictionary);
            }
            deflater.setInput(out2.buf, 0, out2.pos);
            deflater.finish();
            newLen = deflater.deflate(tmp);
        }
        catch (IndexOutOfBoundsException e) {
            newLen = 0;
        }
        if (newLen >= out2.pos || newLen == 0) {
            out.packInt(0);
            out.write(out2.buf, 0, out2.pos);
            return;
        }
        out.packInt(out2.pos + 1);
        out.write(tmp, 0, newLen);
    }

    @Override
    public Object valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        if (size2 == 0) {
            return this.serializer.valueArrayEmpty();
        }
        int unpackedSize = in.unpackInt() - 1;
        if (unpackedSize == -1) {
            return this.serializer.valueArrayDeserialize(in, size2);
        }
        Inflater inflater = new Inflater();
        if (this.dictionary != null) {
            inflater.setDictionary(this.dictionary);
        }
        InflaterInputStream in4 = new InflaterInputStream(new DataInput2.DataInputToStream(in), inflater);
        byte[] unpacked = new byte[unpackedSize];
        in4.read(unpacked, 0, unpackedSize);
        DataInput2.ByteArray in2 = new DataInput2.ByteArray(unpacked);
        Object ret2 = this.serializer.valueArrayDeserialize(in2, size2);
        if (in2.pos != unpackedSize) {
            throw new DBException.DataCorruption("data were not fully read");
        }
        return ret2;
    }

    @Override
    public E valueArrayGet(Object vals, int pos) {
        return this.serializer.valueArrayGet(vals, pos);
    }

    @Override
    public int valueArraySize(Object vals) {
        return this.serializer.valueArraySize(vals);
    }

    @Override
    public Object valueArrayEmpty() {
        return this.serializer.valueArrayEmpty();
    }

    @Override
    public Object valueArrayPut(Object vals, int pos, E newValue) {
        return this.serializer.valueArrayPut(vals, pos, newValue);
    }

    @Override
    public Object valueArrayUpdateVal(Object vals, int pos, E newValue) {
        return this.serializer.valueArrayUpdateVal(vals, pos, newValue);
    }

    @Override
    public Object valueArrayFromArray(Object[] objects) {
        return this.serializer.valueArrayFromArray(objects);
    }

    @Override
    public Object valueArrayCopyOfRange(Object vals, int from, int to) {
        return this.serializer.valueArrayCopyOfRange(vals, from, to);
    }

    @Override
    public Object valueArrayDeleteValue(Object vals, int pos) {
        return this.serializer.valueArrayDeleteValue(vals, pos);
    }

    @Override
    public boolean equals(E a1, E a2) {
        return this.serializer.equals(a1, a2);
    }

    @Override
    public int hashCode(E e, int seed) {
        return this.serializer.hashCode(e, seed);
    }

    @Override
    public int compare(E o1, E o2) {
        return this.serializer.compare(o1, o2);
    }
}

