/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.QueueLong;
import org.mapdb.QueueLongTakeUntil;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.StoreTrivial;
import org.mapdb.Verifiable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\u0018\u0000 32\u00020\u0001:\u000234B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u001bJ&\u0010\u001f\u001a\u00020\u001b2\u001e\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0!J\u000e\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u001e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J\u0016\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u0005J\b\u0010,\u001a\u0004\u0018\u00010(J\u000e\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u000201J\b\u00102\u001a\u00020\u001bH\u0016R$\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\f\u00a8\u00065"}, d2={"Lorg/mapdb/QueueLong;", "Lorg/mapdb/Verifiable;", "store", "Lorg/mapdb/Store;", "tailRecid", "", "headRecid", "headPrevRecid", "(Lorg/mapdb/Store;JJJ)V", "value", "head", "getHead", "()J", "setHead", "(J)V", "headPrev", "getHeadPrev", "setHeadPrev", "getHeadPrevRecid", "getHeadRecid", "getStore", "()Lorg/mapdb/Store;", "tail", "getTail", "setTail", "getTailRecid", "bump", "", "nodeRecid", "newTimestamp", "clear", "forEach", "body", "Lkotlin/Function3;", "printContent", "out", "Ljava/io/PrintStream;", "put", "timestamp", "remove", "Lorg/mapdb/QueueLong$Node;", "removeNode", "", "size", "take", "takeUntil", "f", "Lorg/mapdb/QueueLongTakeUntil;", "valuesArray", "", "verify", "Companion", "Node", "mapdb"})
public final class QueueLong
implements Verifiable {
    @NotNull
    private final Store store;
    private final long tailRecid;
    private final long headRecid;
    private final long headPrevRecid;
    public static final Companion Companion = new Companion(null);

    public final long getTail() {
        Serializer serializer = Serializer.RECID;
        Intrinsics.checkExpressionValueIsNotNull((Object)serializer, (String)"Serializer.RECID");
        Object r = this.store.get(this.tailRecid, serializer);
        if (r == null) {
            Intrinsics.throwNpe();
        }
        return ((Number)r).longValue();
    }

    public final void setTail(long value) {
        Long l = value;
        Serializer serializer = Serializer.RECID;
        Intrinsics.checkExpressionValueIsNotNull((Object)serializer, (String)"Serializer.RECID");
        this.store.update(this.tailRecid, l, serializer);
    }

    public final long getHead() {
        Serializer serializer = Serializer.RECID;
        Intrinsics.checkExpressionValueIsNotNull((Object)serializer, (String)"Serializer.RECID");
        Object r = this.store.get(this.headRecid, serializer);
        if (r == null) {
            Intrinsics.throwNpe();
        }
        return ((Number)r).longValue();
    }

    public final void setHead(long value) {
        Long l = value;
        Serializer serializer = Serializer.RECID;
        Intrinsics.checkExpressionValueIsNotNull((Object)serializer, (String)"Serializer.RECID");
        this.store.update(this.headRecid, l, serializer);
    }

    public final long getHeadPrev() {
        Serializer serializer = Serializer.RECID;
        Intrinsics.checkExpressionValueIsNotNull((Object)serializer, (String)"Serializer.RECID");
        Object r = this.store.get(this.headPrevRecid, serializer);
        if (r == null) {
            Intrinsics.throwNpe();
        }
        return ((Number)r).longValue();
    }

    public final void setHeadPrev(long value) {
        Long l = value;
        Serializer serializer = Serializer.RECID;
        Intrinsics.checkExpressionValueIsNotNull((Object)serializer, (String)"Serializer.RECID");
        this.store.update(this.headPrevRecid, l, serializer);
    }

    public final long put(long timestamp, long value) {
        long nextRecid = this.store.put(null, Node.SERIALIZER.INSTANCE);
        long head2 = this.getHead();
        this.setHead(nextRecid);
        long headPrev2 = this.getHeadPrev();
        this.setHeadPrev(head2);
        Node node = new Node(headPrev2, nextRecid, timestamp, value);
        this.store.update(head2, node, Node.SERIALIZER.INSTANCE);
        return head2;
    }

    public final void put(long timestamp, long value, long nodeRecid) {
        long tail2;
        long prevRecid = this.getHeadPrev();
        long head2 = this.getHead();
        this.store.update(nodeRecid, new Node(prevRecid, head2, timestamp, value), Node.SERIALIZER.INSTANCE);
        this.setHeadPrev(nodeRecid);
        if (prevRecid != 0L) {
            Node node = (Node)this.store.get(prevRecid, Node.SERIALIZER.INSTANCE);
            if (node == null) {
                throw (Throwable)new DBException.DataCorruption("prev node not found");
            }
            Node prevNode = node;
            this.store.update(prevRecid, Node.copy$default(prevNode, 0L, nodeRecid, 0L, 0L, 13, null), Node.SERIALIZER.INSTANCE);
        }
        if ((tail2 = this.getTail()) == head2) {
            this.setTail(nodeRecid);
        }
    }

    @Nullable
    public final Node take() {
        long tail2 = this.getTail();
        Node curr = (Node)this.store.get(tail2, Node.SERIALIZER.INSTANCE);
        if (curr != null) {
            this.store.delete(tail2, Node.SERIALIZER.INSTANCE);
            this.setTail(curr.getNextRecid());
            Long l = tail2;
            Long l2 = 0L;
            Serializer serializer = Serializer.RECID;
            Intrinsics.checkExpressionValueIsNotNull((Object)serializer, (String)"Serializer.RECID");
            this.store.compareAndSwap(this.headPrevRecid, l, l2, serializer);
            Node nextNode = (Node)this.store.get(curr.getNextRecid(), Node.SERIALIZER.INSTANCE);
            if (nextNode != null) {
                this.store.update(curr.getNextRecid(), Node.copy$default(nextNode, 0L, 0L, 0L, 0L, 14, null), Node.SERIALIZER.INSTANCE);
            }
        } else {
            this.setHeadPrev(0L);
        }
        return curr;
    }

    public final void takeUntil(@NotNull QueueLongTakeUntil f) {
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        while (true) {
            Node node;
            long tail2;
            if ((Node)this.store.get(tail2 = this.getTail(), Node.SERIALIZER.INSTANCE) == null) {
                return;
            }
            if (1 != 0 && node.getPrevRecid() != 0L) {
                throw (Throwable)new DBException.DataCorruption("prevRecid not 0");
            }
            boolean taken = f.take(tail2, node);
            if (!taken) {
                return;
            }
            Node nodeTaken = this.take();
            if (1 == 0) continue;
            long l = node.getValue();
            Node node2 = nodeTaken;
            if (node2 == null) {
                Intrinsics.throwNpe();
            }
            if (l != node2.getValue()) break;
        }
        throw (Throwable)new DBException.DataCorruption("wrong nodes");
    }

    @NotNull
    public final Node remove(long nodeRecid, boolean removeNode) {
        Node nextNode;
        Object r = this.store.get(nodeRecid, Node.SERIALIZER.INSTANCE);
        if (r == null) {
            Intrinsics.throwNpe();
        }
        Node node = (Node)r;
        if (removeNode) {
            this.store.delete(nodeRecid, Node.SERIALIZER.INSTANCE);
        }
        if ((nextNode = (Node)this.store.get(node.getNextRecid(), Node.SERIALIZER.INSTANCE)) != null) {
            if (1 != 0 && nextNode.getPrevRecid() != nodeRecid) {
                throw (Throwable)new DBException.DataCorruption("node link error");
            }
            this.store.update(node.getNextRecid(), Node.copy$default(nextNode, node.getPrevRecid(), 0L, 0L, 0L, 14, null), Node.SERIALIZER.INSTANCE);
        } else {
            if (1 != 0 && this.getHeadPrev() != nodeRecid) {
                throw (Throwable)new DBException.DataCorruption("headPrev error");
            }
            this.setHeadPrev(node.getPrevRecid());
        }
        if (node.getPrevRecid() != 0L) {
            Node prevNode = (Node)this.store.get(node.getPrevRecid(), Node.SERIALIZER.INSTANCE);
            if (prevNode != null) {
                if (1 != 0 && prevNode.getNextRecid() != nodeRecid) {
                    throw (Throwable)new DBException.DataCorruption("node link error");
                }
                this.store.update(node.getPrevRecid(), Node.copy$default(prevNode, 0L, node.getNextRecid(), 0L, 0L, 13, null), Node.SERIALIZER.INSTANCE);
            }
        } else {
            if (1 != 0 && this.getTail() != nodeRecid) {
                throw (Throwable)new DBException.DataCorruption("tail error");
            }
            this.setTail(node.getNextRecid());
        }
        return node;
    }

    public final void bump(long nodeRecid, long newTimestamp) {
        Node node;
        Node nextNode;
        long headPrev2 = this.getHeadPrev();
        if (headPrev2 == nodeRecid) {
            Node node2 = (Node)this.store.get(nodeRecid, Node.SERIALIZER.INSTANCE);
            if (node2 == null) {
                throw (Throwable)new DBException.DataCorruption("link error");
            }
            Node node3 = node2;
            this.store.update(nodeRecid, Node.copy$default(node3, 0L, 0L, newTimestamp, 0L, 11, null), Node.SERIALIZER.INSTANCE);
            return;
        }
        Object r = this.store.get(nodeRecid, Node.SERIALIZER.INSTANCE);
        if (r == null) {
            Intrinsics.throwNpe();
        }
        if ((nextNode = (Node)this.store.get((node = (Node)r).getNextRecid(), Node.SERIALIZER.INSTANCE)) != null) {
            if (1 != 0 && nextNode.getPrevRecid() != nodeRecid) {
                throw (Throwable)new DBException.DataCorruption("node link error");
            }
            this.store.update(node.getNextRecid(), Node.copy$default(nextNode, node.getPrevRecid(), 0L, 0L, 0L, 14, null), Node.SERIALIZER.INSTANCE);
        } else {
            if (1 != 0 && this.getHeadPrev() != nodeRecid) {
                throw (Throwable)new DBException.DataCorruption("headPrev error");
            }
            this.setHeadPrev(node.getPrevRecid());
        }
        if (node.getPrevRecid() != 0L) {
            Node prevNode = (Node)this.store.get(node.getPrevRecid(), Node.SERIALIZER.INSTANCE);
            if (prevNode != null) {
                if (1 != 0 && prevNode.getNextRecid() != nodeRecid) {
                    throw (Throwable)new DBException.DataCorruption("node link error");
                }
                this.store.update(node.getPrevRecid(), Node.copy$default(prevNode, 0L, node.getNextRecid(), 0L, 0L, 13, null), Node.SERIALIZER.INSTANCE);
            }
        } else {
            if (1 != 0 && this.getTail() != nodeRecid) {
                throw (Throwable)new DBException.DataCorruption("tail error");
            }
            this.setTail(node.getNextRecid());
        }
        this.setHeadPrev(nodeRecid);
        Object r2 = this.store.get(headPrev2, Node.SERIALIZER.INSTANCE);
        if (r2 == null) {
            Intrinsics.throwNpe();
        }
        Node headPrevNode = (Node)r2;
        this.store.update(headPrev2, Node.copy$default(headPrevNode, 0L, nodeRecid, 0L, 0L, 13, null), Node.SERIALIZER.INSTANCE);
        Node newNode = Node.copy$default(node, headPrev2, headPrevNode.getNextRecid(), newTimestamp, 0L, 8, null);
        this.store.update(nodeRecid, newNode, Node.SERIALIZER.INSTANCE);
    }

    public final void clear() {
        this.takeUntil(clear.1.INSTANCE);
    }

    public final long size() {
        long ret2 = 0L;
        long head = this.getHead();
        long currentRecid = this.getTail();
        while (head != currentRecid) {
            Node node;
            if ((Node)this.store.get(currentRecid, Node.SERIALIZER.INSTANCE) == null) {
                throw (Throwable)new DBException.DataCorruption("linked queue node not found");
            }
            currentRecid = node.getNextRecid();
            long l = ret2;
            ret2 = l + 1L;
        }
        return ret2;
    }

    @Override
    public void verify() {
        long head = this.getHead();
        long tail = this.getTail();
        long headPrev = this.getHeadPrev();
        if (head == tail) {
            if (headPrev != 0L) {
                throw (Throwable)((Object)new AssertionError((Object)"headPrev not 0"));
            }
            return;
        }
        Node node = (Node)this.store.get(tail, Node.SERIALIZER.INSTANCE);
        if (node == null) {
            throw (Throwable)((Object)new AssertionError((Object)"node not found"));
        }
        Node node2 = node;
        if (node2.getPrevRecid() != 0L) {
            throw (Throwable)((Object)new AssertionError((Object)"prevRecid not 0"));
        }
        long prevRecid = tail;
        while (node2.getNextRecid() != head) {
            long recid2 = node2.getNextRecid();
            if ((Node)this.store.get(recid2, Node.SERIALIZER.INSTANCE) == null) {
                throw (Throwable)((Object)new AssertionError((Object)"node not found"));
            }
            if (prevRecid != node2.getPrevRecid()) {
                throw (Throwable)((Object)new AssertionError((Object)"prev recid"));
            }
            prevRecid = recid2;
        }
        if (this.store.get(head, Node.SERIALIZER.INSTANCE) != null) {
            throw (Throwable)((Object)new AssertionError((Object)"prealloc record"));
        }
        if (prevRecid != headPrev) {
            throw (Throwable)((Object)new AssertionError((Object)"wrong headPrevRecid"));
        }
    }

    @NotNull
    public final long[] valuesArray() {
        LongArrayList ret2 = new LongArrayList();
        long currRecid = this.getTail();
        while (true) {
            Node node;
            if ((Node)this.store.get(currRecid, Node.SERIALIZER.INSTANCE) == null) {
                long[] lArray = ret2.toArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)lArray, (String)"ret.toArray()");
                return lArray;
            }
            ret2.add(node.getValue());
            currRecid = node.getNextRecid();
        }
    }

    public final void forEach(@NotNull Function3<? super Long, ? super Long, ? super Long, Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        long currRecid = this.getTail();
        while ((Node)this.store.get(currRecid, Node.SERIALIZER.INSTANCE) != null) {
            Node node;
            body.invoke((Object)currRecid, (Object)node.getValue(), (Object)node.getTimestamp());
            currRecid = node.getNextRecid();
        }
        return;
    }

    public final void printContent(@NotNull PrintStream out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        long currRecid = this.getTail();
        out.println("==============================");
        out.println("TAIL:" + this.getTail() + ", HEAD:" + this.getHead() + ", HEADPREV:" + this.getHeadPrev());
        while ((Node)this.store.get(currRecid, Node.SERIALIZER.INSTANCE) != null) {
            Node node;
            out.println("recid:" + currRecid + ", prev:" + node.getPrevRecid() + ", next:" + node.getNextRecid() + ", timestamp:" + node.getTimestamp() + ", value:" + node.getValue());
            currRecid = node.getNextRecid();
        }
        out.println("==============================");
    }

    @NotNull
    public final Store getStore() {
        return this.store;
    }

    public final long getTailRecid() {
        return this.tailRecid;
    }

    public final long getHeadRecid() {
        return this.headRecid;
    }

    public final long getHeadPrevRecid() {
        return this.headPrevRecid;
    }

    public QueueLong(@NotNull Store store, long tailRecid, long headRecid, long headPrevRecid) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        this.store = store;
        this.tailRecid = tailRecid;
        this.headRecid = headRecid;
        this.headPrevRecid = headPrevRecid;
        if (1 != 0 && this.tailRecid == this.headRecid) {
            throw (Throwable)((Object)new AssertionError((Object)"head==tail"));
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/mapdb/QueueLong$Node;", "", "prevRecid", "", "nextRecid", "timestamp", "value", "(JJJJ)V", "getNextRecid", "()J", "getPrevRecid", "getTimestamp", "getValue", "component1", "component2", "component3", "component4", "copy", "SERIALIZER", "mapdb"})
    public static final class Node {
        private final long prevRecid;
        private final long nextRecid;
        private final long timestamp;
        private final long value;

        public final long getPrevRecid() {
            return this.prevRecid;
        }

        public final long getNextRecid() {
            return this.nextRecid;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final long getValue() {
            return this.value;
        }

        public Node(long prevRecid, long nextRecid, long timestamp, long value) {
            this.prevRecid = prevRecid;
            this.nextRecid = nextRecid;
            this.timestamp = timestamp;
            this.value = value;
        }

        public final long component1() {
            return this.prevRecid;
        }

        public final long component2() {
            return this.nextRecid;
        }

        public final long component3() {
            return this.timestamp;
        }

        public final long component4() {
            return this.value;
        }

        @NotNull
        public final Node copy(long prevRecid, long nextRecid, long timestamp, long value) {
            return new Node(prevRecid, nextRecid, timestamp, value);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Node copy$default(Node node, long l, long l2, long l3, long l4, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                l = node.prevRecid;
            }
            if ((n & 2) != 0) {
                l2 = node.nextRecid;
            }
            if ((n & 4) != 0) {
                l3 = node.timestamp;
            }
            if ((n & 8) != 0) {
                l4 = node.value;
            }
            return node.copy(l, l2, l3, l4);
        }

        public String toString() {
            return "Node(prevRecid=" + this.prevRecid + ", nextRecid=" + this.nextRecid + ", timestamp=" + this.timestamp + ", value=" + this.value + ")";
        }

        public int hashCode() {
            long l = this.prevRecid;
            long l2 = this.nextRecid;
            long l3 = this.timestamp;
            long l4 = this.value;
            return (((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Node)) break block3;
                    Node node = (Node)object;
                    if (!(this.prevRecid == node.prevRecid) || !(this.nextRecid == node.nextRecid) || !(this.timestamp == node.timestamp) || !(this.value == node.value)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/mapdb/QueueLong$Node$SERIALIZER;", "Lorg/mapdb/Serializer;", "Lorg/mapdb/QueueLong$Node;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "mapdb"})
        public static final class SERIALIZER
        implements Serializer<Node> {
            public static final SERIALIZER INSTANCE;

            @Override
            public void serialize(@NotNull DataOutput2 out, @NotNull Node value) {
                Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Serializer.RECID.serialize(out, value.getPrevRecid());
                Serializer.RECID.serialize(out, value.getNextRecid());
                out.packLong(value.getTimestamp());
                out.packLong(value.getValue());
            }

            @Override
            @Nullable
            public Node deserialize(@NotNull DataInput2 input, int available) {
                Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                return new Node(((Number)Serializer.RECID.deserialize(input, -1)).longValue(), ((Number)Serializer.RECID.deserialize(input, -1)).longValue(), input.unpackLong(), input.unpackLong());
            }

            private SERIALIZER() {
                INSTANCE = this;
            }

            static {
                new SERIALIZER();
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lorg/mapdb/QueueLong$Companion;", "", "()V", "make", "Lorg/mapdb/QueueLong;", "store", "Lorg/mapdb/Store;", "tailRecid", "", "headRecid", "headPrevRecid", "mapdb"})
    public static final class Companion {
        @NotNull
        public final QueueLong make(@NotNull Store store, long tailRecid, long headRecid, long headPrevRecid) {
            Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
            return new QueueLong(store, tailRecid, headRecid, headPrevRecid);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ QueueLong make$default(Companion companion, Store store, long l, long l2, long l3, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: make");
            }
            if ((n & 1) != 0) {
                store = new StoreTrivial(false, 1, null);
            }
            if ((n & 2) != 0) {
                Long l4 = store.put(null, Node.SERIALIZER.INSTANCE);
                Serializer serializer = Serializer.RECID;
                Intrinsics.checkExpressionValueIsNotNull((Object)serializer, (String)"Serializer.RECID");
                l = store.put(l4, serializer);
            }
            if ((n & 4) != 0) {
                Serializer serializer = Serializer.RECID;
                Intrinsics.checkExpressionValueIsNotNull((Object)serializer, (String)"Serializer.RECID");
                Object r = store.get(l, serializer);
                Serializer serializer2 = Serializer.RECID;
                Intrinsics.checkExpressionValueIsNotNull((Object)serializer2, (String)"Serializer.RECID");
                l2 = store.put(r, serializer2);
            }
            if ((n & 8) != 0) {
                Long l5 = 0L;
                Serializer serializer = Serializer.RECID;
                Intrinsics.checkExpressionValueIsNotNull((Object)serializer, (String)"Serializer.RECID");
                l3 = store.put(l5, serializer);
            }
            return companion.make(store, l, l2, l3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

