/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapdb.DataIO;
import org.mapdb.Fun;
import org.mapdb.Volume;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class UnsafeStuff {
    static final Logger LOG = Logger.getLogger(UnsafeStuff.class.getName());
    static final Unsafe UNSAFE = UnsafeStuff.getUnsafe();
    private static final long BYTE_ARRAY_OFFSET = UNSAFE == null ? -1L : (long)UNSAFE.arrayBaseOffset(byte[].class);
    private static final int BYTE_ARRAY_SCALE = UNSAFE == null ? -1 : UNSAFE.arrayIndexScale(byte[].class);
    private static final long INT_ARRAY_OFFSET = UNSAFE == null ? -1L : (long)UNSAFE.arrayBaseOffset(int[].class);
    private static final int INT_ARRAY_SCALE = UNSAFE == null ? -1 : UNSAFE.arrayIndexScale(int[].class);
    private static final long SHORT_ARRAY_OFFSET = UNSAFE == null ? -1L : (long)UNSAFE.arrayBaseOffset(short[].class);
    private static final int SHORT_ARRAY_SCALE = UNSAFE == null ? -1 : UNSAFE.arrayIndexScale(short[].class);
    private static final long CHAR_ARRAY_OFFSET = UNSAFE == null ? -1L : (long)UNSAFE.arrayBaseOffset(char[].class);
    private static final int CHAR_ARRAY_SCALE = UNSAFE == null ? -1 : UNSAFE.arrayIndexScale(char[].class);

    UnsafeStuff() {
    }

    private static Unsafe getUnsafe() {
        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
            LOG.log(Level.WARNING, "This is not Little Endian platform. Unsafe optimizations are disabled.");
            return null;
        }
        try {
            Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            Unsafe ret = (Unsafe)singleoneInstanceField.get(null);
            return ret;
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, "Could not instantiate sun.misc.Unsafe. Fall back to DirectByteBuffer and other alternatives.", e);
            return null;
        }
    }

    public static boolean unsafeAvailable() {
        return UNSAFE != null;
    }

    public static long hash(byte[] buf, int off, int len, long seed) {
        long h64;
        if (UNSAFE == null) {
            return DataIO.hash(buf, off, len, seed);
        }
        if (len < 0) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
        if (off < 0 || off > buf.length || off + len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        int end = off + len;
        if (len >= 32) {
            int limit = end - 32;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed + 0L;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += UnsafeStuff.readLongLE(buf, off) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += UnsafeStuff.readLongLE(buf, off += 8) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += UnsafeStuff.readLongLE(buf, off += 8) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += UnsafeStuff.readLongLE(buf, off += 8) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
            } while ((off += 8) <= limit);
            h64 = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            h64 ^= (v1 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            h64 ^= (v2 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            h64 ^= (v3 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            h64 ^= (v4 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
        } else {
            h64 = seed + 2870177450012600261L;
        }
        h64 += (long)len;
        while (off <= end - 8) {
            long k1 = UnsafeStuff.readLongLE(buf, off);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            h64 ^= (k1 *= -7046029288634856825L);
            h64 = Long.rotateLeft(h64, 27) * -7046029288634856825L + -8796714831421723037L;
            off += 8;
        }
        if (off <= end - 4) {
            h64 ^= ((long)UnsafeStuff.readIntLE(buf, off) & 0xFFFFFFFFL) * -7046029288634856825L;
            h64 = Long.rotateLeft(h64, 23) * -4417276706812531889L + 1609587929392839161L;
            off += 4;
        }
        while (off < end) {
            h64 ^= (long)(buf[off] & 0xFF) * 2870177450012600261L;
            h64 = Long.rotateLeft(h64, 11) * -7046029288634856825L;
            ++off;
        }
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        h64 *= 1609587929392839161L;
        h64 ^= h64 >>> 32;
        return h64;
    }

    public static long readLongLE(byte[] src, int srcOff) {
        return UNSAFE.getLong(src, BYTE_ARRAY_OFFSET + (long)srcOff);
    }

    public static int readIntLE(byte[] src, int srcOff) {
        return UNSAFE.getInt(src, BYTE_ARRAY_OFFSET + (long)srcOff);
    }

    public static long hash(char[] buf, int off, int len, long seed) {
        long h64;
        if (UNSAFE == null) {
            return DataIO.hash(buf, off, len, seed);
        }
        if (len < 0) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
        if (off < 0 || off > buf.length || off + len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        int end = off + len;
        if (len >= 16) {
            int limit = end - 16;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed + 0L;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += UnsafeStuff.readLongLE(buf, off) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += UnsafeStuff.readLongLE(buf, off += 4) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += UnsafeStuff.readLongLE(buf, off += 4) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += UnsafeStuff.readLongLE(buf, off += 4) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
            } while ((off += 4) <= limit);
            h64 = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            h64 ^= (v1 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            h64 ^= (v2 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            h64 ^= (v3 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            h64 ^= (v4 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
        } else {
            h64 = seed + 2870177450012600261L;
        }
        h64 += (long)len;
        while (off <= end - 4) {
            long k1 = UnsafeStuff.readLongLE(buf, off);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            h64 ^= (k1 *= -7046029288634856825L);
            h64 = Long.rotateLeft(h64, 27) * -7046029288634856825L + -8796714831421723037L;
            off += 4;
        }
        if (off <= end - 2) {
            h64 ^= ((long)UnsafeStuff.readIntLE(buf, off) & 0xFFFFFFFFL) * -7046029288634856825L;
            h64 = Long.rotateLeft(h64, 23) * -4417276706812531889L + 1609587929392839161L;
            off += 2;
        }
        while (off < end) {
            h64 ^= (long)(UnsafeStuff.readCharLE(buf, off) & 0xFFFF) * 2870177450012600261L;
            h64 = Long.rotateLeft(h64, 11) * -7046029288634856825L;
            ++off;
        }
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        h64 *= 1609587929392839161L;
        h64 ^= h64 >>> 32;
        return h64;
    }

    public static long readLongLE(char[] src, int srcOff) {
        return UNSAFE.getLong(src, CHAR_ARRAY_OFFSET + (long)(srcOff * CHAR_ARRAY_SCALE));
    }

    public static int readIntLE(char[] src, int srcOff) {
        return UNSAFE.getInt(src, CHAR_ARRAY_OFFSET + (long)(srcOff * CHAR_ARRAY_SCALE));
    }

    public static char readCharLE(char[] src, int srcOff) {
        return UNSAFE.getChar(src, CHAR_ARRAY_OFFSET + (long)(srcOff * CHAR_ARRAY_SCALE));
    }

    static final class UnsafeVolume
    extends Volume {
        private static final long ARRAY_BASE_OFFSET = UNSAFE == null ? -1L : (long)UNSAFE.arrayBaseOffset(byte[].class);
        public static final Volume.VolumeFactory FACTORY = new Volume.VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisable, int sliceShift, long initSize, boolean fixedSize) {
                return new UnsafeVolume(0L, sliceShift, initSize);
            }
        };
        static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
        protected volatile long[] addresses = new long[0];
        protected volatile DirectBuffer[] buffers = new DirectBuffer[0];
        protected final long sizeLimit;
        protected final boolean hasLimit;
        protected final int sliceShift;
        protected final int sliceSizeModMask;
        protected final int sliceSize;
        protected final ReentrantLock growLock = new ReentrantLock(false);

        public static boolean unsafeAvailable() {
            return UNSAFE != null;
        }

        static void copyFromArray(byte[] src, long srcPos, long dstAddr, long length) {
            long offset = ARRAY_BASE_OFFSET + srcPos;
            while (length > 0L) {
                long size = length > 0x100000L ? 0x100000L : length;
                UNSAFE.copyMemory(src, offset, null, dstAddr, size);
                length -= size;
                offset += size;
                dstAddr += size;
            }
        }

        static void copyToArray(long srcAddr, byte[] dst, long dstPos, long length) {
            long offset = ARRAY_BASE_OFFSET + dstPos;
            while (length > 0L) {
                long size = length > 0x100000L ? 0x100000L : length;
                UNSAFE.copyMemory(null, srcAddr, dst, offset, size);
                length -= size;
                srcAddr += size;
                offset += size;
            }
        }

        public UnsafeVolume() {
            this(0L, 20, 0L);
        }

        public UnsafeVolume(long sizeLimit, int sliceShift, long initSize) {
            this.sizeLimit = sizeLimit;
            this.hasLimit = sizeLimit > 0L;
            this.sliceShift = sliceShift;
            this.sliceSize = 1 << sliceShift;
            this.sliceSizeModMask = this.sliceSize - 1;
            if (initSize != 0L) {
                this.ensureAvailable(initSize);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ensureAvailable(long offset) {
            offset = Fun.roundUp(offset, 1L << this.sliceShift);
            if (this.hasLimit && offset > this.sizeLimit) {
                throw new IllegalAccessError("too big");
            }
            int slicePos = (int)(offset >>> this.sliceShift);
            if (slicePos < this.addresses.length) {
                return;
            }
            this.growLock.lock();
            try {
                if (slicePos <= this.addresses.length) {
                    return;
                }
                int oldSize = this.addresses.length;
                long[] addresses2 = this.addresses;
                DirectBuffer[] buffers2 = this.buffers;
                int newSize = slicePos;
                addresses2 = Arrays.copyOf(addresses2, newSize);
                buffers2 = Arrays.copyOf(buffers2, newSize);
                for (int pos = oldSize; pos < addresses2.length; ++pos) {
                    DirectBuffer buf = (DirectBuffer)((Object)ByteBuffer.allocateDirect(this.sliceSize));
                    long address = buf.address();
                    for (long i = 0L; i < (long)this.sliceSize; i += 8L) {
                        UNSAFE.putLong(address + i, 0L);
                    }
                    buffers2[pos] = buf;
                    addresses2[pos] = address;
                }
                this.addresses = addresses2;
                this.buffers = buffers2;
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        public void truncate(long size) {
        }

        @Override
        public void putLong(long offset, long value) {
            value = Long.reverseBytes(value);
            long address = this.addresses[(int)(offset >>> this.sliceShift)];
            UNSAFE.putLong(address + (offset &= (long)this.sliceSizeModMask), value);
        }

        @Override
        public void putInt(long offset, int value) {
            value = Integer.reverseBytes(value);
            long address = this.addresses[(int)(offset >>> this.sliceShift)];
            UNSAFE.putInt(address + (offset &= (long)this.sliceSizeModMask), value);
        }

        @Override
        public void putByte(long offset, byte value) {
            long address = this.addresses[(int)(offset >>> this.sliceShift)];
            UNSAFE.putByte(address + (offset &= (long)this.sliceSizeModMask), value);
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            long address = this.addresses[(int)(offset >>> this.sliceShift)];
            UnsafeVolume.copyFromArray(src, srcPos, address + (offset &= (long)this.sliceSizeModMask), srcSize);
        }

        @Override
        public void putData(long offset, ByteBuffer buf) {
            long address = this.addresses[(int)(offset >>> this.sliceShift)];
            offset &= (long)this.sliceSizeModMask;
            for (int pos = buf.position(); pos < buf.limit(); ++pos) {
                UNSAFE.putByte(address + offset + (long)pos, buf.get(pos));
            }
        }

        @Override
        public long getLong(long offset) {
            long address = this.addresses[(int)(offset >>> this.sliceShift)];
            long l = UNSAFE.getLong(address + (offset &= (long)this.sliceSizeModMask));
            return Long.reverseBytes(l);
        }

        @Override
        public int getInt(long offset) {
            long address = this.addresses[(int)(offset >>> this.sliceShift)];
            int i = UNSAFE.getInt(address + (offset &= (long)this.sliceSizeModMask));
            return Integer.reverseBytes(i);
        }

        @Override
        public byte getByte(long offset) {
            long address = this.addresses[(int)(offset >>> this.sliceShift)];
            return UNSAFE.getByte(address + (offset &= (long)this.sliceSizeModMask));
        }

        @Override
        public DataInput getDataInput(long offset, int size) {
            long address = this.addresses[(int)(offset >>> this.sliceShift)];
            return new DataInputUnsafe(address, (int)(offset &= (long)this.sliceSizeModMask));
        }

        @Override
        public void getData(long offset, byte[] bytes, int bytesPos, int size) {
            long address = this.addresses[(int)(offset >>> this.sliceShift)];
            UnsafeVolume.copyToArray(address + (offset &= (long)this.sliceSizeModMask), bytes, bytesPos, size);
        }

        @Override
        public void putDataOverlap(long offset, byte[] data, int pos, int len) {
            boolean overlap;
            boolean bl = overlap = offset >>> this.sliceShift != offset + (long)len >>> this.sliceShift;
            if (overlap) {
                while (len > 0) {
                    long addr = this.addresses[(int)(offset >>> this.sliceShift)];
                    long pos2 = offset & (long)this.sliceSizeModMask;
                    long toPut = Math.min((long)len, (long)this.sliceSize - pos2);
                    UnsafeVolume.copyFromArray(data, pos, addr + pos2, toPut);
                    pos = (int)((long)pos + toPut);
                    len = (int)((long)len - toPut);
                    offset += toPut;
                }
            } else {
                this.putData(offset, data, pos, len);
            }
        }

        @Override
        public DataInput getDataInputOverlap(long offset, int size) {
            boolean overlap;
            boolean bl = overlap = offset >>> this.sliceShift != offset + (long)size >>> this.sliceShift;
            if (overlap) {
                byte[] bb = new byte[size];
                int origLen = size;
                while (size > 0) {
                    long addr = this.addresses[(int)(offset >>> this.sliceShift)];
                    long pos = offset & (long)this.sliceSizeModMask;
                    long toPut = Math.min((long)size, (long)this.sliceSize - pos);
                    UnsafeVolume.copyToArray(addr + pos, bb, origLen - size, toPut);
                    size = (int)((long)size - toPut);
                    offset += toPut;
                }
                return new DataIO.DataInputByteArray(bb);
            }
            return this.getDataInput(offset, size);
        }

        @Override
        public void close() {
            this.closed = true;
            DirectBuffer[] buf2 = this.buffers;
            this.buffers = null;
            this.addresses = null;
            for (DirectBuffer buf : buf2) {
                buf.cleaner().clean();
            }
        }

        @Override
        public void sync() {
        }

        @Override
        public int sliceSize() {
            return this.sliceSize;
        }

        @Override
        public boolean isSliced() {
            return true;
        }

        @Override
        public long length() {
            return 1L * (long)this.addresses.length * (long)this.sliceSize;
        }

        @Override
        public File getFile() {
            return null;
        }

        @Override
        public boolean getFileLocked() {
            return false;
        }

        @Override
        public void clear(long startOffset, long endOffset) {
            while (startOffset < endOffset) {
                this.putByte(startOffset++, (byte)0);
            }
        }

        public static final class DataInputUnsafe
        implements DataIO.DataInputInternal {
            protected final long baseAdress;
            protected long pos2;

            public DataInputUnsafe(long baseAdress, int pos) {
                this.baseAdress = baseAdress;
                this.pos2 = baseAdress + (long)pos;
            }

            @Override
            public int getPos() {
                return (int)(this.pos2 - this.baseAdress);
            }

            @Override
            public void setPos(int pos) {
                this.pos2 = this.baseAdress + (long)pos;
            }

            @Override
            public byte[] internalByteArray() {
                return null;
            }

            @Override
            public ByteBuffer internalByteBuffer() {
                return null;
            }

            @Override
            public void close() {
            }

            @Override
            public long unpackLong() throws IOException {
                byte v;
                Unsafe UNSAFE = UnsafeStuff.UNSAFE;
                long pos = this.pos2;
                long ret = 0L;
                do {
                    v = UNSAFE.getByte(pos++);
                    ret = ret << 7 | (long)(v & 0x7F);
                } while (v < 0);
                this.pos2 = pos;
                return ret;
            }

            @Override
            public int unpackInt() throws IOException {
                byte v;
                Unsafe UNSAFE = UnsafeStuff.UNSAFE;
                long pos = this.pos2;
                int ret = 0;
                do {
                    v = UNSAFE.getByte(pos++);
                    ret = ret << 7 | v & 0x7F;
                } while (v < 0);
                this.pos2 = pos;
                return ret;
            }

            @Override
            public long[] unpackLongArrayDeltaCompression(int size) throws IOException {
                Unsafe UNSAFE = UnsafeStuff.UNSAFE;
                long[] ret = new long[size];
                long pos2_ = this.pos2;
                long prev = 0L;
                for (int i = 0; i < size; ++i) {
                    byte v;
                    long r = 0L;
                    do {
                        v = UNSAFE.getByte(pos2_++);
                        r = r << 7 | (long)(v & 0x7F);
                    } while (v < 0);
                    ret[i] = prev += r;
                }
                this.pos2 = pos2_;
                return ret;
            }

            @Override
            public void unpackLongArray(long[] array, int start, int end) {
                Unsafe UNSAFE = UnsafeStuff.UNSAFE;
                long pos2_ = this.pos2;
                while (start < end) {
                    byte v;
                    long ret = 0L;
                    do {
                        v = UNSAFE.getByte(pos2_++);
                        ret = ret << 7 | (long)(v & 0x7F);
                    } while (v < 0);
                    array[start] = ret;
                    ++start;
                }
                this.pos2 = pos2_;
            }

            @Override
            public void unpackIntArray(int[] array, int start, int end) {
                Unsafe UNSAFE = UnsafeStuff.UNSAFE;
                long pos2_ = this.pos2;
                while (start < end) {
                    byte v;
                    int ret = 0;
                    do {
                        v = UNSAFE.getByte(pos2_++);
                        ret = ret << 7 | v & 0x7F;
                    } while (v < 0);
                    array[start] = ret;
                    ++start;
                }
                this.pos2 = pos2_;
            }

            @Override
            public void readFully(byte[] b) throws IOException {
                UnsafeVolume.copyToArray(this.pos2, b, 0L, b.length);
                this.pos2 += (long)b.length;
            }

            @Override
            public void readFully(byte[] b, int off, int len) throws IOException {
                UnsafeVolume.copyToArray(this.pos2, b, off, len);
                this.pos2 += (long)len;
            }

            @Override
            public int skipBytes(int n) throws IOException {
                this.pos2 += (long)n;
                return n;
            }

            @Override
            public boolean readBoolean() throws IOException {
                return this.readByte() == 1;
            }

            @Override
            public byte readByte() throws IOException {
                return UNSAFE.getByte(this.pos2++);
            }

            @Override
            public int readUnsignedByte() throws IOException {
                return UNSAFE.getByte(this.pos2++) & 0xFF;
            }

            @Override
            public short readShort() throws IOException {
                return (short)(this.readByte() << 8 | this.readByte() & 0xFF);
            }

            @Override
            public int readUnsignedShort() throws IOException {
                return this.readChar();
            }

            @Override
            public char readChar() throws IOException {
                return (char)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
            }

            @Override
            public int readInt() throws IOException {
                int ret = UNSAFE.getInt(this.pos2);
                this.pos2 += 4L;
                return Integer.reverseBytes(ret);
            }

            @Override
            public long readLong() throws IOException {
                long ret = UNSAFE.getLong(this.pos2);
                this.pos2 += 8L;
                return Long.reverseBytes(ret);
            }

            @Override
            public float readFloat() throws IOException {
                return Float.intBitsToFloat(this.readInt());
            }

            @Override
            public double readDouble() throws IOException {
                return Double.longBitsToDouble(this.readLong());
            }

            @Override
            public String readLine() throws IOException {
                return this.readUTF();
            }

            @Override
            public String readUTF() throws IOException {
                int len = this.unpackInt();
                char[] b = new char[len];
                for (int i = 0; i < len; ++i) {
                    b[i] = (char)this.unpackInt();
                }
                return new String(b);
            }
        }
    }
}

