/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jxls.builder.JxlsStreaming;
import org.jxls.logging.JxlsLogger;
import org.jxls.transform.JxlsTransformerFactory;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.PoiTransformer;
import org.jxls.transform.poi.SelectSheetsForStreamingPoiTransformer;
import org.jxls.util.CannotOpenWorkbookException;

public class PoiTransformerFactory
implements JxlsTransformerFactory {
    public Transformer create(InputStream template, OutputStream outputStream, JxlsStreaming streaming, JxlsLogger logger) {
        Workbook workbook = PoiTransformerFactory.openWorkbook(template);
        Transformer transformer = this.createTransformer(workbook, streaming);
        transformer.setLogger(logger);
        transformer.setOutputStream(outputStream);
        return transformer;
    }

    public static Workbook openWorkbook(InputStream template) {
        try {
            return WorkbookFactory.create((InputStream)template);
        }
        catch (Exception e) {
            throw new CannotOpenWorkbookException((Throwable)e);
        }
    }

    protected Transformer createTransformer(Workbook workbook, JxlsStreaming streaming) {
        if (streaming.isAutoDetect()) {
            return new SelectSheetsForStreamingPoiTransformer(workbook, PoiTransformerFactory.getAllSheetsInWhichStreamingIsConfigured(workbook), streaming.getRowAccessWindowSize(), streaming.isCompressTmpFiles(), streaming.isUseSharedStringsTable());
        }
        if (streaming.getSheetNames() != null) {
            return new SelectSheetsForStreamingPoiTransformer(workbook, streaming.getSheetNames(), streaming.getRowAccessWindowSize(), streaming.isCompressTmpFiles(), streaming.isUseSharedStringsTable());
        }
        if (streaming.isStreaming()) {
            return new SelectSheetsForStreamingPoiTransformer(workbook, true, streaming.getRowAccessWindowSize(), streaming.isCompressTmpFiles(), streaming.isUseSharedStringsTable());
        }
        return new PoiTransformer(workbook, false);
    }

    public static Set<String> getAllSheetsInWhichStreamingIsConfigured(Workbook workbook) {
        HashSet<String> sheetNames = new HashSet<String>();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            if (!PoiTransformerFactory.isStreamingEnabled(sheet)) continue;
            sheetNames.add(sheet.getSheetName());
        }
        return sheetNames;
    }

    public static boolean isStreamingEnabled(Sheet sheet) {
        for (Comment comment : sheet.getCellComments().values()) {
            String text = comment.getString().getString();
            if (!text.contains("sheetStreaming=\"true\"")) continue;
            return true;
        }
        return false;
    }
}

