/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.template;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.jxls.area.Area;
import org.jxls.area.CommandData;
import org.jxls.builder.xls.XlsCommentAreaBuilder;
import org.jxls.command.GridCommand;
import org.jxls.command.ImageCommand;
import org.jxls.common.JxlsException;
import org.jxls.transform.poi.JxlsPoiTemplateFillerBuilder;

public class SimpleExporter {
    public static final String GRID_TEMPLATE_XLS = "grid_template.xlsx";
    private byte[] templateBytes;

    public void registerGridTemplate(InputStream inputStream) throws IOException {
        this.templateBytes = ImageCommand.toByteArray(inputStream);
    }

    public void gridExport(Iterable<?> headers, Iterable<?> dataObjects, String objectProps, OutputStream outputStream) {
        if (this.templateBytes == null) {
            InputStream is = SimpleExporter.class.getResourceAsStream(GRID_TEMPLATE_XLS);
            try {
                this.registerGridTemplate(is);
            }
            catch (IOException e) {
                throw new JxlsException("Failed to read default template file grid_template.xlsx", (Throwable)e);
            }
        }
        HashMap data = new HashMap();
        data.put("headers", headers);
        data.put("data", dataObjects);
        ((JxlsPoiTemplateFillerBuilder)((JxlsPoiTemplateFillerBuilder)JxlsPoiTemplateFillerBuilder.newInstance().withTemplate(new ByteArrayInputStream(this.templateBytes))).withAreaBuilder((transformer, ctc) -> {
            List areas = new XlsCommentAreaBuilder().build(transformer, ctc);
            GridCommand gridCommand = (GridCommand)((CommandData)((Area)areas.get(0)).getCommandDataList().get(0)).getCommand();
            gridCommand.setProps(objectProps);
            return areas;
        })).buildAndFill(data, () -> outputStream);
    }
}

