/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.common;

import org.jxls.common.Context;
import org.jxls.common.JxlsException;
import org.jxls.logging.JxlsLogger;

public class PoiExceptionThrower
implements JxlsLogger {
    public void handleCellException(Exception e, String cell, Context context) {
        throw new JxlsException("Failed to write a cell with " + cell, (Throwable)e);
    }

    public void handleFormulaException(Exception e, String cell, String formula) {
        throw new JxlsException("Failed to set formula \"" + formula + "\" into cell " + cell, (Throwable)e);
    }

    public void handleTransformException(Exception e, String sourceCell, String targetCell) {
        throw new JxlsException("Failed to transform " + sourceCell + " into " + targetCell + "\n" + e.getMessage(), (Throwable)e);
    }

    public void handleUpdateRowHeightsException(Exception e, int sourceRow, int targetRow) {
        throw new JxlsException("Failed to update row height for source row " + sourceRow + " and target row " + targetRow, (Throwable)e);
    }

    public void handleEvaluationException(Exception e, String cell, String expression) {
        throw new JxlsException("Failed to evaluate collection expression \"" + expression + "\" in each command at " + cell, (Throwable)e);
    }

    public void handleGetObjectPropertyException(Exception e, Object obj, String propertyName) {
        throw new JxlsException("Failed to get property '" + propertyName + "' of object " + obj, (Throwable)e);
    }

    public void handleSetObjectPropertyException(Exception e, Object obj, String propertyName, String propertyValue) {
        throw new JxlsException("Failed to set property '" + propertyName + "' to value '" + propertyValue + "' for object " + obj, (Throwable)e);
    }

    public void handleSheetNameChange(String invalidSheetName, String newSheetName) {
        this.info("Change invalid sheet name " + invalidSheetName + " to " + newSheetName);
    }

    public void debug(String msg) {
    }

    public void info(String msg) {
        System.out.println("JXLS [INFO] " + msg);
    }

    public void warn(String msg) {
        this.write("WARN", msg, null);
    }

    public void warn(Throwable e, String msg) {
        this.write("WARN", msg, e);
    }

    public void error(String msg) {
        throw new JxlsException(msg);
    }

    public void error(Throwable e, String msg) {
        throw new JxlsException(msg, e);
    }

    protected void write(String level, String msg, Throwable e) {
        System.err.println("JXLS [" + level + "] " + msg);
        if (e != null) {
            e.printStackTrace();
        }
    }
}

