/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.util.Date;
import java.util.Map;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.transform.poi.PoiTransformer;
import org.jxls.transform.poi.PoiUtil;
import org.jxls.transform.poi.WritableCellValue;
import org.jxls.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiCellData
extends CellData {
    static Logger logger = LoggerFactory.getLogger(PoiCellData.class);
    RichTextString richTextString;
    private CellStyle cellStyle;
    private Hyperlink hyperlink;
    private Comment comment;
    private String commentAuthor;
    private Cell cell;

    public PoiCellData(CellRef cellRef) {
        super(cellRef);
    }

    public PoiCellData(CellRef cellRef, Cell cell) {
        super(cellRef);
        this.cell = cell;
    }

    public static PoiCellData createCellData(CellRef cellRef, Cell cell) {
        PoiCellData cellData = new PoiCellData(cellRef, cell);
        cellData.readCell(cell);
        cellData.updateFormulaValue();
        return cellData;
    }

    public void readCell(Cell cell) {
        this.readCellGeneralInfo(cell);
        this.readCellContents(cell);
        this.readCellStyle(cell);
    }

    private void readCellGeneralInfo(Cell cell) {
        this.hyperlink = cell.getHyperlink();
        try {
            this.comment = cell.getCellComment();
        }
        catch (Exception e) {
            logger.error("Failed to read cell comment at " + new CellReference(cell).formatAsString(), (Throwable)e);
            return;
        }
        if (this.comment != null) {
            this.commentAuthor = this.comment.getAuthor();
        }
        if (this.comment != null && this.comment.getString() != null) {
            String[] commentLines;
            String commentString = this.comment.getString().getString();
            for (String commentLine : commentLines = commentString.split("\\n")) {
                if (!this.isJxlsParamsComment(commentLine)) continue;
                this.processJxlsParams(commentLine);
                this.comment = null;
                return;
            }
            this.setCellComment(commentString);
        }
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    private void readCellContents(Cell cell) {
        switch (cell.getCellTypeEnum()) {
            case STRING: {
                this.richTextString = cell.getRichStringCellValue();
                this.cellValue = this.richTextString.getString();
                this.cellType = CellData.CellType.STRING;
                break;
            }
            case BOOLEAN: {
                this.cellValue = cell.getBooleanCellValue();
                this.cellType = CellData.CellType.BOOLEAN;
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    this.cellValue = cell.getDateCellValue();
                    this.cellType = CellData.CellType.DATE;
                    break;
                }
                this.cellValue = cell.getNumericCellValue();
                this.cellType = CellData.CellType.NUMBER;
                break;
            }
            case FORMULA: {
                this.formula = cell.getCellFormula();
                this.cellValue = this.formula;
                this.cellType = CellData.CellType.FORMULA;
                break;
            }
            case ERROR: {
                this.cellValue = cell.getErrorCellValue();
                this.cellType = CellData.CellType.ERROR;
                break;
            }
            case BLANK: {
                this.cellValue = null;
                this.cellType = CellData.CellType.BLANK;
            }
        }
        this.evaluationResult = this.cellValue;
    }

    private void readCellStyle(Cell cell) {
        this.cellStyle = cell.getCellStyle();
    }

    public void writeToCell(Cell cell, Context context, PoiTransformer transformer) {
        this.evaluate(context);
        if (this.evaluationResult != null && this.evaluationResult instanceof WritableCellValue) {
            cell.setCellStyle(this.cellStyle);
            ((WritableCellValue)this.evaluationResult).writeToCell(cell, context);
        } else {
            CellStyle dataFormatCellStyle;
            this.updateCellGeneralInfo(cell);
            this.updateCellContents(cell);
            CellStyle targetCellStyle = this.cellStyle;
            if (context.getConfig().isIgnoreSourceCellStyle() && (dataFormatCellStyle = this.findCellStyle(this.evaluationResult, context.getConfig().getCellStyleMap(), transformer)) != null) {
                targetCellStyle = dataFormatCellStyle;
            }
            this.updateCellStyle(cell, targetCellStyle);
        }
    }

    private CellStyle findCellStyle(Object evaluationResult, Map<String, String> cellStyleMap, PoiTransformer transformer) {
        if (evaluationResult == null || cellStyleMap == null) {
            return null;
        }
        String cellName = cellStyleMap.get(evaluationResult.getClass().getSimpleName());
        if (cellName == null) {
            return null;
        }
        Sheet sheet = this.cell.getSheet();
        CellRef cellRef = new CellRef(cellName);
        if (cellRef.getSheetName() == null) {
            cellRef.setSheetName(sheet.getSheetName());
        }
        return transformer.getCellStyle(cellRef);
    }

    private void updateCellGeneralInfo(Cell cell) {
        cell.setCellType(PoiCellData.getPoiCellType(this.targetCellType));
        if (this.hyperlink != null) {
            cell.setHyperlink(this.hyperlink);
        }
        if (this.comment != null && !PoiUtil.isJxComment(this.getCellComment())) {
            PoiUtil.setCellComment(cell, this.getCellComment(), this.commentAuthor, null);
        }
    }

    static CellType getPoiCellType(CellData.CellType cellType) {
        if (cellType == null) {
            return CellType.BLANK;
        }
        switch (cellType) {
            case STRING: {
                return CellType.STRING;
            }
            case BOOLEAN: {
                return CellType.BOOLEAN;
            }
            case NUMBER: 
            case DATE: {
                return CellType.NUMERIC;
            }
            case FORMULA: {
                return CellType.FORMULA;
            }
            case ERROR: {
                return CellType.ERROR;
            }
            case BLANK: {
                return CellType.BLANK;
            }
        }
        return CellType.BLANK;
    }

    private void updateCellContents(Cell cell) {
        switch (this.targetCellType) {
            case STRING: {
                if (this.evaluationResult instanceof byte[]) break;
                String result = this.evaluationResult != null ? this.evaluationResult.toString() : "";
                cell.setCellValue(result);
                break;
            }
            case BOOLEAN: {
                cell.setCellValue(((Boolean)this.evaluationResult).booleanValue());
                break;
            }
            case DATE: {
                cell.setCellValue((Date)this.evaluationResult);
                break;
            }
            case NUMBER: {
                cell.setCellValue(((Number)this.evaluationResult).doubleValue());
                break;
            }
            case FORMULA: {
                try {
                    if (Util.formulaContainsJointedCellRef((String)((String)this.evaluationResult))) {
                        cell.setCellValue((String)this.evaluationResult);
                        break;
                    }
                    cell.setCellFormula((String)this.evaluationResult);
                }
                catch (FormulaParseException e) {
                    try {
                        String formulaString = this.evaluationResult.toString();
                        logger.error("Failed to set cell formula " + formulaString + " for cell " + this.toString(), (Throwable)e);
                        cell.setCellType(CellType.STRING);
                        cell.setCellValue(formulaString);
                    }
                    catch (Exception ex) {
                        logger.warn("Failed to convert formula to string for cell " + this.toString());
                    }
                }
                break;
            }
            case ERROR: {
                cell.setCellErrorValue(((Byte)this.evaluationResult).byteValue());
            }
        }
    }

    private void updateCellStyle(Cell cell, CellStyle cellStyle) {
        cell.setCellStyle(cellStyle);
    }
}

