/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.jexcel;

import jxl.Range;
import jxl.Sheet;
import org.jxls.common.SheetData;
import org.jxls.transform.Transformer;
import org.jxls.transform.jexcel.JexcelRowData;
import org.jxls.transform.jexcel.JexcelTransformer;

public class JexcelSheetData
extends SheetData {
    Sheet sheet;
    Range[] mergedCells;

    public static JexcelSheetData createSheetData(Sheet sheet, JexcelTransformer transformer) {
        JexcelSheetData sheetData = new JexcelSheetData();
        sheetData.setTransformer((Transformer)transformer);
        sheetData.sheet = sheet;
        sheetData.sheetName = sheet.getName();
        sheetData.columnWidth = new int[256];
        for (int i = 0; i < 256; ++i) {
            sheetData.columnWidth[i] = sheet.getColumnView(i).getSize();
        }
        int numberOfRows = sheet.getRows();
        for (int i = 0; i < numberOfRows; ++i) {
            sheetData.rowDataList.add(JexcelRowData.createRowData(sheet, i, transformer));
        }
        sheetData.mergedCells = sheet.getMergedCells();
        return sheetData;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public Range[] getMergedCells() {
        return this.mergedCells;
    }
}

