/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jxls.area.XlsArea;
import org.jxls.common.AreaRef;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.JxlsException;
import org.jxls.expression.ExpressionEvaluator;
import org.jxls.transform.TransformationConfig;
import org.jxls.transform.Transformer;
import org.jxls.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellData {
    private static final String USER_FORMULA_PREFIX = "$[";
    private static final String USER_FORMULA_SUFFIX = "]";
    private static final String ATTR_PREFIX = "(";
    private static final String ATTR_SUFFIX = ")";
    public static final String JX_PARAMS_PREFIX = "jx:params";
    private static final String ATTR_REGEX = "\\s*\\w+\\s*=\\s*([\"|'\u201c\u201d\u201e\u201f\u2033\u2036\u2018\u2019\u201a\u201b\u2032\u2035])(?:(?!\\1).)*\\1";
    private static final Pattern ATTR_REGEX_PATTERN = Pattern.compile("\\s*\\w+\\s*=\\s*([\"|'\u201c\u201d\u201e\u201f\u2033\u2036\u2018\u2019\u201a\u201b\u2032\u2035])(?:(?!\\1).)*\\1");
    private static final String FORMULA_STRATEGY_PARAM = "formulaStrategy";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static Logger logger = LoggerFactory.getLogger(CellData.class);
    private Map<String, String> attrMap;
    protected CellRef cellRef;
    protected Object cellValue;
    protected CellType cellType;
    private String cellComment;
    protected String formula;
    protected Object evaluationResult;
    protected CellType targetCellType;
    private FormulaStrategy formulaStrategy = FormulaStrategy.DEFAULT;
    private String defaultValue;
    protected XlsArea area;
    private List<CellRef> targetPos = new ArrayList<CellRef>();
    private List<AreaRef> targetParentAreaRef = new ArrayList<AreaRef>();
    private Transformer transformer;
    private List<String> evaluatedFormulas = new ArrayList<String>();

    public CellData(CellRef cellRef) {
        this.cellRef = cellRef;
    }

    public CellData(String sheetName, int row, int col, CellType cellType, Object cellValue) {
        this.cellRef = new CellRef(sheetName, row, col);
        this.cellType = cellType;
        this.cellValue = cellValue;
        this.updateFormulaValue();
    }

    public CellData(CellRef cellRef, CellType cellType, Object cellValue) {
        this.cellRef = cellRef;
        this.cellType = cellType;
        this.cellValue = cellValue;
        this.updateFormulaValue();
    }

    public CellData(String sheetName, int row, int col) {
        this(sheetName, row, col, CellType.BLANK, null);
    }

    protected void updateFormulaValue() {
        if (this.cellType == CellType.FORMULA) {
            this.formula = this.cellValue != null ? this.cellValue.toString() : "";
        } else if (this.cellType == CellType.STRING && this.cellValue != null && CellData.isUserFormula(this.cellValue.toString())) {
            this.formula = this.cellValue.toString().substring(2, this.cellValue.toString().length() - 1);
        }
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public XlsArea getArea() {
        return this.area;
    }

    public void setArea(XlsArea area) {
        this.area = area;
    }

    public Map<String, String> getAttrMap() {
        return this.attrMap;
    }

    public void setAttrMap(Map<String, String> attrMap) {
        this.attrMap = attrMap;
    }

    public void setEvaluationResult(Object evaluationResult) {
        this.evaluationResult = evaluationResult;
    }

    private ExpressionEvaluator getExpressionEvaluator() {
        return this.transformer.getTransformationConfig().getExpressionEvaluator();
    }

    public FormulaStrategy getFormulaStrategy() {
        return this.formulaStrategy;
    }

    public void setFormulaStrategy(FormulaStrategy formulaStrategy) {
        this.formulaStrategy = formulaStrategy;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getCellComment() {
        return this.cellComment;
    }

    public void setCellComment(String cellComment) {
        this.cellComment = cellComment;
    }

    protected boolean isJxlsParamsComment(String cellComment) {
        return cellComment.trim().startsWith(JX_PARAMS_PREFIX);
    }

    public String getSheetName() {
        return this.cellRef.getSheetName();
    }

    public CellRef getCellRef() {
        return this.cellRef;
    }

    public CellType getCellType() {
        return this.cellType;
    }

    public void setCellType(CellType cellType) {
        this.cellType = cellType;
    }

    public Object getCellValue() {
        return this.cellValue;
    }

    public int getRow() {
        return this.cellRef.getRow();
    }

    public int getCol() {
        return this.cellRef.getCol();
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public List<String> getEvaluatedFormulas() {
        return this.evaluatedFormulas;
    }

    public boolean isFormulaCell() {
        return this.formula != null;
    }

    public boolean isParameterizedFormulaCell() {
        return this.isFormulaCell() && CellData.isUserFormula(this.cellValue.toString());
    }

    public boolean isJointedFormulaCell() {
        return this.isParameterizedFormulaCell() && Util.formulaContainsJointedCellRef(this.cellValue.toString());
    }

    public boolean addTargetPos(CellRef cellRef) {
        return this.targetPos.add(cellRef);
    }

    public void addTargetParentAreaRef(AreaRef areaRef) {
        this.targetParentAreaRef.add(areaRef);
    }

    public List<AreaRef> getTargetParentAreaRef() {
        return this.targetParentAreaRef;
    }

    public void setEvaluatedFormulas(List<String> evaluatedFormulas) {
        this.evaluatedFormulas = evaluatedFormulas;
    }

    public List<CellRef> getTargetPos() {
        return this.targetPos;
    }

    public void resetTargetPos() {
        this.targetPos.clear();
        this.targetParentAreaRef.clear();
    }

    public Object evaluate(Context context) {
        this.targetCellType = this.cellType;
        if (this.cellType == CellType.STRING && this.cellValue != null) {
            String strValue = this.cellValue.toString();
            if (CellData.isUserFormula(strValue)) {
                String formulaStr = strValue.substring(USER_FORMULA_PREFIX.length(), strValue.length() - USER_FORMULA_SUFFIX.length());
                this.evaluate(formulaStr, context);
                if (this.evaluationResult != null) {
                    this.targetCellType = CellType.FORMULA;
                    this.formula = this.evaluationResult.toString();
                    this.evaluatedFormulas.add(this.formula);
                }
            } else {
                this.evaluate(strValue, context);
            }
            if (this.evaluationResult == null) {
                this.targetCellType = CellType.BLANK;
            }
        }
        return this.evaluationResult;
    }

    private static boolean isUserFormula(String str) {
        return str.startsWith(USER_FORMULA_PREFIX) && str.endsWith(USER_FORMULA_SUFFIX);
    }

    private void evaluate(String strValue, Context context) {
        boolean isAppendTail;
        StringBuffer sb = new StringBuffer();
        TransformationConfig transformationConfig = this.transformer.getTransformationConfig();
        int beginExpressionLength = transformationConfig.getExpressionNotationBegin().length();
        int endExpressionLength = transformationConfig.getExpressionNotationEnd().length();
        Matcher exprMatcher = transformationConfig.getExpressionNotationPattern().matcher(strValue);
        ExpressionEvaluator evaluator = this.getExpressionEvaluator();
        Object lastMatchEvalResult = null;
        int matchCount = 0;
        int endOffset = 0;
        while (exprMatcher.find()) {
            endOffset = exprMatcher.end();
            ++matchCount;
            String matchedString = exprMatcher.group();
            String expression = matchedString.substring(beginExpressionLength, matchedString.length() - endExpressionLength);
            lastMatchEvalResult = evaluator.evaluate(expression, context.toMap());
            exprMatcher.appendReplacement(sb, Matcher.quoteReplacement(lastMatchEvalResult != null ? lastMatchEvalResult.toString() : ""));
        }
        String lastStringResult = lastMatchEvalResult != null ? lastMatchEvalResult.toString() : "";
        boolean bl = isAppendTail = matchCount == 1 && endOffset < strValue.length();
        if (matchCount > 1 || isAppendTail) {
            exprMatcher.appendTail(sb);
            this.evaluationResult = sb.toString();
        } else if (matchCount == 1) {
            if (sb.length() > lastStringResult.length()) {
                this.evaluationResult = sb.toString();
            } else {
                this.evaluationResult = lastMatchEvalResult;
                this.setTargetCellType();
            }
        } else if (matchCount == 0) {
            this.evaluationResult = strValue;
        }
    }

    private void setTargetCellType() {
        if (this.evaluationResult instanceof Number) {
            this.targetCellType = CellType.NUMBER;
        } else if (this.evaluationResult instanceof Boolean) {
            this.targetCellType = CellType.BOOLEAN;
        } else if (this.evaluationResult instanceof Date) {
            this.targetCellType = CellType.DATE;
        }
    }

    protected void processJxlsParams(String cellComment) {
        int nameEndIndex = cellComment.indexOf(ATTR_PREFIX, JX_PARAMS_PREFIX.length());
        if (nameEndIndex < 0) {
            String errMsg = "Failed to parse jxls params [" + cellComment + "] at " + this.cellRef.getCellName() + ". Expected '" + ATTR_PREFIX + "' symbol.";
            logger.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        this.attrMap = this.buildAttrMap(cellComment, nameEndIndex);
        if (this.attrMap.containsKey(FORMULA_STRATEGY_PARAM)) {
            this.initFormulaStrategy(this.attrMap.get(FORMULA_STRATEGY_PARAM));
        }
        if (this.attrMap.containsKey(DEFAULT_VALUE)) {
            this.defaultValue = this.attrMap.get(DEFAULT_VALUE);
        }
    }

    private Map<String, String> buildAttrMap(String paramsLine, int nameEndIndex) {
        int paramsEndIndex = paramsLine.lastIndexOf(ATTR_SUFFIX);
        if (paramsEndIndex < 0) {
            String errMsg = "Failed to parse params line [" + paramsLine + "] at " + this.cellRef.getCellName() + ". Expected '" + ATTR_SUFFIX + "' symbol.";
            logger.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        String attrString = paramsLine.substring(nameEndIndex + 1, paramsEndIndex).trim();
        return this.parseCommandAttributes(attrString);
    }

    private Map<String, String> parseCommandAttributes(String attrString) {
        LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>();
        Matcher attrMatcher = ATTR_REGEX_PATTERN.matcher(attrString);
        while (attrMatcher.find()) {
            String attrData = attrMatcher.group();
            int attrNameEndIndex = attrData.indexOf("=");
            String attrName = attrData.substring(0, attrNameEndIndex).trim();
            String attrValuePart = attrData.substring(attrNameEndIndex + 1).trim();
            String attrValue = attrValuePart.substring(1, attrValuePart.length() - 1);
            attrMap.put(attrName, attrValue);
        }
        return attrMap;
    }

    private void initFormulaStrategy(String formulaStrategyValue) {
        try {
            this.formulaStrategy = FormulaStrategy.valueOf(formulaStrategyValue);
        }
        catch (IllegalArgumentException e) {
            throw new JxlsException("Cannot parse formula strategy value at " + this.cellRef.getCellName(), e);
        }
    }

    public String toString() {
        return "CellData{" + this.cellRef + ", cellType=" + (Object)((Object)this.cellType) + ", cellValue=" + this.cellValue + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CellData)) {
            return false;
        }
        CellData cellData = (CellData)o;
        if (this.cellType != cellData.cellType) {
            return false;
        }
        if (this.cellValue != null ? !this.cellValue.equals(cellData.cellValue) : cellData.cellValue != null) {
            return false;
        }
        return this.cellRef != null ? this.cellRef.equals(cellData.cellRef) : cellData.cellRef == null;
    }

    public int hashCode() {
        int result = this.cellRef != null ? this.cellRef.hashCode() : 0;
        result = 31 * result + (this.cellValue != null ? this.cellValue.hashCode() : 0);
        result = 31 * result + (this.cellType != null ? this.cellType.hashCode() : 0);
        return result;
    }

    public static enum FormulaStrategy {
        DEFAULT,
        BY_COLUMN,
        BY_ROW;

    }

    public static enum CellType {
        STRING,
        NUMBER,
        BOOLEAN,
        DATE,
        FORMULA,
        BLANK,
        ERROR;

    }
}

