/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.common;

import org.jxls.common.CellRef;
import org.jxls.common.Size;
import org.jxls.util.CellRefUtil;

public class AreaRef {
    private CellRef firstCellRef;
    private CellRef lastCellRef;
    private int startRow;
    private int startCol;
    private int endRow;
    private int endCol;

    public AreaRef(CellRef firstCellRef, CellRef lastCellRef) {
        if (!(firstCellRef.getSheetName() == null && lastCellRef.getSheetName() == null || firstCellRef.getSheetName() != null && firstCellRef.getSheetName().equalsIgnoreCase(lastCellRef.getSheetName()))) {
            throw new IllegalArgumentException("Cannot create area from specified cell references " + firstCellRef + ", " + lastCellRef);
        }
        this.firstCellRef = firstCellRef;
        this.lastCellRef = lastCellRef;
        this.updateStartEndRowCol();
    }

    public AreaRef(CellRef cellRef, Size size) {
        this.firstCellRef = cellRef;
        this.lastCellRef = new CellRef(cellRef.getSheetName(), cellRef.getRow() + size.getHeight() - 1, cellRef.getCol() + size.getWidth() - 1);
        this.updateStartEndRowCol();
    }

    public AreaRef(String areaRef) {
        String[] parts = CellRefUtil.separateAreaRefs(areaRef);
        String part0 = parts[0];
        if (parts.length == 1) {
            this.lastCellRef = this.firstCellRef = new CellRef(part0);
            this.updateStartEndRowCol();
            return;
        }
        if (parts.length != 2) {
            throw new IllegalArgumentException("Bad area ref '" + areaRef + "'");
        }
        String part1 = parts[1];
        if (CellRefUtil.isPlainColumn(part0) || CellRefUtil.isPlainColumn(part1)) {
            throw new IllegalArgumentException("Plain column references are not currently supported");
        }
        this.firstCellRef = new CellRef(part0);
        this.lastCellRef = new CellRef(part1);
        this.updateStartEndRowCol();
    }

    private void updateStartEndRowCol() {
        this.startRow = this.firstCellRef.getRow();
        this.startCol = this.firstCellRef.getCol();
        this.endRow = this.lastCellRef.getRow();
        this.endCol = this.lastCellRef.getCol();
    }

    public String getSheetName() {
        return this.firstCellRef.getSheetName();
    }

    public CellRef getFirstCellRef() {
        return this.firstCellRef;
    }

    public CellRef getLastCellRef() {
        return this.lastCellRef;
    }

    public Size getSize() {
        if (this.firstCellRef == null || this.lastCellRef == null) {
            return Size.ZERO_SIZE;
        }
        return new Size(this.endCol - this.startCol + 1, this.endRow - this.startRow + 1);
    }

    public boolean contains(CellRef cellRef) {
        String sheetName = this.getSheetName();
        String otherSheetName = cellRef.getSheetName();
        if (sheetName == null && otherSheetName == null || sheetName != null && sheetName.equalsIgnoreCase(otherSheetName)) {
            return cellRef.getRow() >= this.startRow && cellRef.getCol() >= this.startCol && cellRef.getRow() <= this.endRow && cellRef.getCol() <= this.endCol;
        }
        return false;
    }

    public boolean contains(int row, int col) {
        return row >= this.startRow && row <= this.endRow && col >= this.startCol && col <= this.endCol;
    }

    public boolean contains(AreaRef areaRef) {
        if (areaRef == null) {
            return true;
        }
        if (this.getSheetName() == null && areaRef.getSheetName() == null || this.getSheetName() != null && this.getSheetName().equalsIgnoreCase(areaRef.getSheetName())) {
            return this.contains(areaRef.getFirstCellRef()) && this.contains(areaRef.getLastCellRef());
        }
        return false;
    }

    public String toString() {
        return this.firstCellRef.toString() + ":" + this.lastCellRef.toString(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaRef areaRef = (AreaRef)o;
        if (this.firstCellRef != null ? !this.firstCellRef.equals(areaRef.firstCellRef) : areaRef.firstCellRef != null) {
            return false;
        }
        return !(this.lastCellRef != null ? !this.lastCellRef.equals(areaRef.lastCellRef) : areaRef.lastCellRef != null);
    }

    public int hashCode() {
        int result = this.firstCellRef != null ? this.firstCellRef.hashCode() : 0;
        result = 31 * result + (this.lastCellRef != null ? this.lastCellRef.hashCode() : 0);
        return result;
    }
}

