/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.jxls.area.Area;
import org.jxls.command.AbstractCommand;
import org.jxls.command.Command;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.util.UtilWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "grid";
    public static final String HEADER_VAR = "header";
    public static final String DATA_VAR = "cell";
    private static Logger logger = LoggerFactory.getLogger(GridCommand.class);
    private String headers;
    private String data;
    private String props;
    private String formatCells;
    private Map<String, String> cellStyleMap = new HashMap<String, String>();
    private List<String> rowObjectProps = new ArrayList<String>();
    private Area headerArea;
    private Area bodyArea;
    private UtilWrapper util = new UtilWrapper();

    public GridCommand() {
    }

    public GridCommand(String headers, String data) {
        this.headers = headers;
        this.data = data;
    }

    public GridCommand(String headers, String data, String props, Area headerArea, Area bodyArea) {
        this(headers, data, headerArea, bodyArea);
        this.props = props;
    }

    public GridCommand(String headers, String data, Area headerArea, Area bodyArea) {
        this.headers = headers;
        this.data = data;
        this.headerArea = headerArea;
        this.bodyArea = bodyArea;
        this.addArea(headerArea);
        this.addArea(bodyArea);
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String props) {
        this.props = props;
        if (props != null) {
            this.rowObjectProps = Arrays.asList(props.replaceAll("\\s+", "").split(","));
        }
    }

    public String getFormatCells() {
        return this.formatCells;
    }

    public void setFormatCells(String formatCells) {
        this.formatCells = formatCells;
        if (formatCells != null) {
            List<String> cellStyleList = Arrays.asList(formatCells.split(","));
            try {
                for (String cellStyleString : cellStyleList) {
                    String[] styleCell = cellStyleString.split(":");
                    this.cellStyleMap.put(styleCell[0].trim(), styleCell[1].trim());
                }
            }
            catch (Exception e) {
                logger.error("Failed to parse formatCells attribute");
            }
        }
    }

    @Override
    public Command addArea(Area area) {
        if (this.areaList.size() >= 2) {
            throw new IllegalArgumentException("Cannot add any more areas to GridCommand. You can add only 1 area as a 'header' and 1 area as a 'body'.");
        }
        if (this.areaList.isEmpty()) {
            this.headerArea = area;
        } else {
            this.bodyArea = area;
        }
        return super.addArea(area);
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        Size headerAreaSize = this.processHeaders(cellRef, context);
        CellRef bodyCellRef = new CellRef(cellRef.getSheetName(), cellRef.getRow() + headerAreaSize.getHeight(), cellRef.getCol());
        Size bodyAreaSize = this.processBody(bodyCellRef, context);
        int gridHeight = headerAreaSize.getHeight() + bodyAreaSize.getHeight();
        int gridWidth = Math.max(headerAreaSize.getWidth(), bodyAreaSize.getWidth());
        return new Size(gridWidth, gridHeight);
    }

    private Size processHeaders(CellRef cellRef, Context context) {
        if (this.headerArea == null || this.headers == null) {
            return Size.ZERO_SIZE;
        }
        Iterable<Object> headers = this.util.transformToIterableObject(this.getTransformationConfig().getExpressionEvaluator(), this.headers, context);
        CellRef currentCell = cellRef;
        int width = 0;
        int height = 0;
        for (Object header : headers) {
            context.putVar(HEADER_VAR, header);
            Size size = this.headerArea.applyAt(currentCell, context);
            currentCell = new CellRef(currentCell.getSheetName(), currentCell.getRow(), currentCell.getCol() + size.getWidth());
            width += size.getWidth();
            height = Math.max(height, size.getHeight());
        }
        context.removeVar(HEADER_VAR);
        return new Size(width, height);
    }

    private Size processBody(CellRef cellRef, Context context) {
        if (this.bodyArea == null || this.data == null) {
            return Size.ZERO_SIZE;
        }
        Iterable<Object> dataCollection = this.util.transformToIterableObject(this.getTransformationConfig().getExpressionEvaluator(), this.data, context);
        CellRef currentCell = cellRef;
        int totalWidth = 0;
        int totalHeight = 0;
        Context.Config config = context.getConfig();
        boolean oldIgnoreSourceCellStyle = config.isIgnoreSourceCellStyle();
        config.setIgnoreSourceCellStyle(true);
        Map<String, String> oldStyleCellMap = config.getCellStyleMap();
        config.setCellStyleMap(this.cellStyleMap);
        for (Object rowObject : dataCollection) {
            Size size;
            if (rowObject.getClass().isArray() || rowObject instanceof Iterable) {
                List<Object> cellCollection = null;
                cellCollection = rowObject.getClass().isArray() ? Arrays.asList((Object[])rowObject) : (List<Object>)rowObject;
                int width = 0;
                int height = 0;
                for (Object t : cellCollection) {
                    context.putVar(DATA_VAR, t);
                    size = this.bodyArea.applyAt(currentCell, context);
                    currentCell = new CellRef(currentCell.getSheetName(), currentCell.getRow(), currentCell.getCol() + size.getWidth());
                    width += size.getWidth();
                    height = Math.max(height, size.getHeight());
                }
                totalWidth = Math.max(width, totalWidth);
                totalHeight += height;
                currentCell = new CellRef(cellRef.getSheetName(), currentCell.getRow() + height, cellRef.getCol());
                continue;
            }
            if (this.rowObjectProps.isEmpty()) {
                throw new IllegalArgumentException("Got a non-collection object type for a Grid row but object properties list is empty");
            }
            int width = 0;
            int height = 0;
            for (String prop : this.rowObjectProps) {
                try {
                    Object object = PropertyUtils.getProperty((Object)rowObject, (String)prop);
                    context.putVar(DATA_VAR, object);
                    size = this.bodyArea.applyAt(currentCell, context);
                    currentCell = new CellRef(currentCell.getSheetName(), currentCell.getRow(), currentCell.getCol() + size.getWidth());
                    width += size.getWidth();
                    height = Math.max(height, size.getHeight());
                }
                catch (Exception exception) {
                    String message = "Failed to evaluate property " + prop + " of row object of class " + rowObject.getClass().getName();
                    logger.error(message, (Throwable)exception);
                    throw new IllegalStateException(message, exception);
                }
            }
            totalWidth = Math.max(width, totalWidth);
            totalHeight += height;
            currentCell = new CellRef(cellRef.getSheetName(), currentCell.getRow() + height, cellRef.getCol());
        }
        context.removeVar(DATA_VAR);
        config.setIgnoreSourceCellStyle(oldIgnoreSourceCellStyle);
        config.setCellStyleMap(oldStyleCellMap);
        return new Size(totalWidth, totalHeight);
    }
}

