/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import java.util.HashSet;
import java.util.Set;
import org.jxls.command.CellRefGenerator;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.expression.ExpressionEvaluator;

public class DynamicSheetNameGenerator
implements CellRefGenerator {
    private final Set<String> names = new HashSet<String>();
    private final String sheetName;
    private final CellRef startCellRef;
    private final ExpressionEvaluator expressionEvaluator;

    public DynamicSheetNameGenerator(String sheetName, CellRef startCellRef, ExpressionEvaluator expressionEvaluator) {
        this.sheetName = sheetName;
        this.startCellRef = startCellRef;
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    public CellRef generateCellRef(int index, Context context) {
        String name = (String)this.expressionEvaluator.evaluate(this.sheetName, context.toMap());
        if (name == null) {
            return null;
        }
        if (!this.names.add(name)) {
            int i = 1;
            while (true) {
                String tmp;
                if (this.names.add(tmp = name + '(' + i + ')')) {
                    name = tmp;
                    break;
                }
                ++i;
            }
        }
        return new CellRef(name, this.startCellRef.getRow(), this.startCellRef.getCol());
    }
}

