/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import java.util.HashSet;
import java.util.Set;
import org.jxls.command.CellRefGenerator;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.expression.ExpressionEvaluator;

public class DynamicSheetNameGenerator
implements CellRefGenerator {
    private String sheetName;
    private Set<String> names = new HashSet<String>();
    private CellRef startCellRef;
    private ExpressionEvaluator expressionEvaluator;

    public DynamicSheetNameGenerator(String sheetName, CellRef startCellRef, ExpressionEvaluator expressionEvaluator) {
        this.sheetName = sheetName;
        this.startCellRef = startCellRef;
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    public CellRef generateCellRef(int index, Context context) {
        String name = (String)this.expressionEvaluator.evaluate(this.sheetName, context.toMap());
        if (name == null) {
            return null;
        }
        if (this.names.contains(name)) {
            String tmp;
            int i = 1;
            while (!this.names.add(tmp = name + '(' + i + ')')) {
                ++i;
            }
            name = tmp;
        } else {
            this.names.add(name);
        }
        return new CellRef(name, this.startCellRef.getRow(), this.startCellRef.getCol());
    }
}

