/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.formula;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jxls.common.AreaRef;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.formula.FormulaProcessor;
import org.jxls.transform.Transformer;
import org.jxls.util.Util;

public class StandardFormulaProcessor
implements FormulaProcessor {
    private static final int MAX_NUM_ARGS_FOR_SUM = 255;

    @Override
    public void processAreaFormulas(Transformer transformer) {
        Set<CellData> formulaCells = transformer.getFormulaCells();
        for (CellData formulaCellData : formulaCells) {
            List<String> formulaCellRefs = Util.getFormulaCellRefs(formulaCellData.getFormula());
            List<String> jointedCellRefs = Util.getJointedCellRefs(formulaCellData.getFormula());
            List<CellRef> targetFormulaCells = formulaCellData.getTargetPos();
            LinkedHashMap<CellRef, List<CellRef>> targetCellRefMap = new LinkedHashMap<CellRef, List<CellRef>>();
            LinkedHashMap jointedCellRefMap = new LinkedHashMap();
            for (String cellRef : formulaCellRefs) {
                CellRef pos = new CellRef(cellRef);
                if (!pos.isValid()) continue;
                if (pos.getSheetName() == null) {
                    pos.setSheetName(formulaCellData.getSheetName());
                    pos.setIgnoreSheetNameInFormat(true);
                }
                List<CellRef> targetCellDataList = transformer.getTargetCellRef(pos);
                targetCellRefMap.put(pos, targetCellDataList);
            }
            for (String jointedCellRef : jointedCellRefs) {
                List<String> nestedCellRefs = Util.getCellRefsFromJointedCellRef(jointedCellRef);
                ArrayList jointedCellRefList = new ArrayList();
                for (String cellRef : nestedCellRefs) {
                    CellRef pos = new CellRef(cellRef);
                    if (pos.getSheetName() == null) {
                        pos.setSheetName(formulaCellData.getSheetName());
                        pos.setIgnoreSheetNameInFormat(true);
                    }
                    Iterator targetCellDataList = transformer.getTargetCellRef(pos);
                    jointedCellRefList.addAll(targetCellDataList);
                }
                jointedCellRefMap.put(jointedCellRef, jointedCellRefList);
            }
            ArrayList<CellRef> usedCellRefs = new ArrayList<CellRef>();
            for (int i = 0; i < targetFormulaCells.size(); ++i) {
                CellRef targetFormulaCellRef = targetFormulaCells.get(i);
                String targetFormulaString = formulaCellData.getFormula();
                AreaRef formulaSourceAreaRef = formulaCellData.getArea().getAreaRef();
                AreaRef formulaTargetAreaRef = formulaCellData.getTargetParentAreaRef().get(i);
                boolean isFormulaCellRefsEmpty = true;
                for (Map.Entry entry : targetCellRefMap.entrySet()) {
                    List targetCells = (List)entry.getValue();
                    if (targetCells.isEmpty()) continue;
                    isFormulaCellRefsEmpty = false;
                    List<CellRef> replacementCells = this.findFormulaCellRefReplacements(formulaSourceAreaRef, formulaTargetAreaRef, entry);
                    if (formulaCellData.getFormulaStrategy() == CellData.FormulaStrategy.BY_COLUMN) {
                        replacementCells = Util.createTargetCellRefListByColumn(targetFormulaCellRef, replacementCells, usedCellRefs);
                        usedCellRefs.addAll(replacementCells);
                    }
                    String replacementString = Util.createTargetCellRef(replacementCells);
                    if (targetFormulaString.startsWith("SUM") && Util.countOccurences(replacementString, ',') >= 255) {
                        targetFormulaString = replacementString.replaceAll(",", "+");
                        System.out.println(targetFormulaString);
                        continue;
                    }
                    targetFormulaString = targetFormulaString.replaceAll("(?<!U_\\([^)]{0,100})" + Util.sheetNameRegex(entry) + Pattern.quote(((CellRef)entry.getKey()).getCellName()), Matcher.quoteReplacement(replacementString));
                }
                for (Map.Entry entry : jointedCellRefMap.entrySet()) {
                    List targetCellRefList = (List)entry.getValue();
                    Collections.sort(targetCellRefList);
                    if (targetCellRefList.isEmpty()) continue;
                    isFormulaCellRefsEmpty = false;
                    AbstractMap.SimpleImmutableEntry<Object, List> cellRefMapEntryParam = new AbstractMap.SimpleImmutableEntry<Object, List>(null, targetCellRefList);
                    List<CellRef> replacementCells = this.findFormulaCellRefReplacements(formulaSourceAreaRef, formulaTargetAreaRef, cellRefMapEntryParam);
                    String replacementString = Util.createTargetCellRef(replacementCells);
                    targetFormulaString = targetFormulaString.replaceAll(Pattern.quote((String)entry.getKey()), replacementString);
                }
                String sheetNameReplacementRegex = targetFormulaCellRef.getFormattedSheetName() + '!';
                targetFormulaString = targetFormulaString.replaceAll(sheetNameReplacementRegex, "");
                if (isFormulaCellRefsEmpty) {
                    String string = targetFormulaString = formulaCellData.getDefaultValue() != null ? formulaCellData.getDefaultValue() : "0";
                }
                if (targetFormulaString.isEmpty()) continue;
                transformer.setFormula(new CellRef(targetFormulaCellRef.getSheetName(), targetFormulaCellRef.getRow(), targetFormulaCellRef.getCol()), targetFormulaString);
            }
        }
    }

    private List<CellRef> findFormulaCellRefReplacements(AreaRef formulaSourceAreaRef, AreaRef formulaTargetAreaRef, Map.Entry<CellRef, List<CellRef>> cellReferenceEntry) {
        CellRef cellReference = cellReferenceEntry.getKey();
        List<CellRef> cellReferenceTargets = cellReferenceEntry.getValue();
        if (cellReference != null && !formulaSourceAreaRef.contains(cellReference)) {
            return cellReferenceTargets;
        }
        List<CellRef> relevantCellRefs = this.findRelevantCellReferences(cellReferenceTargets, formulaTargetAreaRef);
        return relevantCellRefs;
    }

    private List<CellRef> findRelevantCellReferences(List<CellRef> cellReferenceTargets, AreaRef targetFormulaArea) {
        ArrayList<CellRef> relevantCellRefs = new ArrayList<CellRef>(cellReferenceTargets.size());
        for (CellRef targetCellRef : cellReferenceTargets) {
            if (!targetFormulaArea.contains(targetCellRef)) continue;
            relevantCellRefs.add(targetCellRef);
        }
        return relevantCellRefs;
    }
}

