/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jxls.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerFactory {
    public static final String POI_CLASS_NAME = "org.jxls.transform.poi.PoiTransformer";
    public static final String JEXCEL_CLASS_NAME = "org.jxls.transform.jexcel.JexcelTransformer";
    public static final String INIT_METHOD = "createTransformer";
    public static final String TRANSFORMER_SYSTEM_PROPERTY = "jxlstransformer";
    public static final String JEXCEL_TRANSFORMER = "jexcel";
    public static final String POI_TRANSFORMER = "poi";
    private static Logger logger = LoggerFactory.getLogger(TransformerFactory.class);

    public static Transformer createTransformer(InputStream inputStream, OutputStream outputStream) {
        Class transformer = TransformerFactory.getTransformerClass();
        if (transformer == null) {
            logger.error("Cannot load any Transformer class. Please make sure you have necessary libraries in CLASSPATH.");
            return null;
        }
        logger.debug("Transformer class is " + transformer.getName());
        try {
            Method initMethod = transformer.getMethod(INIT_METHOD, InputStream.class, OutputStream.class);
            return (Transformer)initMethod.invoke(null, inputStream, outputStream);
        }
        catch (NoSuchMethodException e) {
            logger.error("The specified public method createTransformer does not exist in " + transformer.getName());
            return null;
        }
        catch (InvocationTargetException e) {
            logger.error("Method createTransformer of " + transformer.getName() + " class thrown an Exception", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error("Method createTransformer of " + transformer.getName() + " is inaccessible", (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            logger.error("Failed to execute method createTransformer of " + transformer.getName(), (Throwable)e);
            return null;
        }
    }

    public static String getTransformerName() {
        Class transformerClass = TransformerFactory.getTransformerClass();
        if (transformerClass == null) {
            return null;
        }
        if (POI_CLASS_NAME.equalsIgnoreCase(transformerClass.getName())) {
            return POI_TRANSFORMER;
        }
        if (JEXCEL_CLASS_NAME.equalsIgnoreCase(transformerClass.getName())) {
            return JEXCEL_TRANSFORMER;
        }
        return transformerClass.getName();
    }

    private static Class getTransformerClass() {
        String transformerName = System.getProperty(TRANSFORMER_SYSTEM_PROPERTY);
        Class transformer = null;
        if (transformerName == null) {
            transformer = TransformerFactory.loadPoiTransformer();
            if (transformer == null) {
                transformer = TransformerFactory.loadJexcelTransformer();
            }
        } else if (POI_TRANSFORMER.equalsIgnoreCase(transformerName)) {
            transformer = TransformerFactory.loadPoiTransformer();
        } else if (JEXCEL_TRANSFORMER.equalsIgnoreCase(transformerName)) {
            transformer = TransformerFactory.loadJexcelTransformer();
        }
        return transformer;
    }

    private static Class loadPoiTransformer() {
        try {
            return Class.forName(POI_CLASS_NAME);
        }
        catch (Exception e) {
            logger.info("Cannot load POI transformer class");
            return null;
        }
    }

    private static Class loadJexcelTransformer() {
        try {
            return Class.forName(JEXCEL_CLASS_NAME);
        }
        catch (Exception e) {
            logger.info("Cannot load JExcel transformer class");
            return null;
        }
    }
}

