/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.common;

import org.jxls.util.CellRefUtil;

public class CellRef
implements Comparable<CellRef> {
    static CellRef NONE = new CellRef("NONE", -1, -1);
    private int col;
    private int row;
    private String sheetName;
    private boolean isColAbs;
    private boolean isRowAbs;
    private boolean ignoreSheetNameInFormat = false;

    public CellRef(String sheetName, int row, int col) {
        this.sheetName = sheetName;
        this.row = row;
        this.col = col;
    }

    public CellRef(int row, int col) {
        this(null, row, col);
    }

    public CellRef(String cellRef) {
        if (cellRef.endsWith("#REF!")) {
            throw new IllegalArgumentException("Cell reference invalid: " + cellRef);
        }
        String[] parts = CellRefUtil.separateRefParts(cellRef);
        this.sheetName = parts[0];
        String colRef = parts[1];
        if (colRef.length() < 1) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + cellRef + "'");
        }
        boolean bl = this.isColAbs = colRef.charAt(0) == '$';
        if (this.isColAbs) {
            colRef = colRef.substring(1);
        }
        this.col = CellRefUtil.convertColStringToIndex(colRef);
        String rowRef = parts[2];
        if (rowRef.length() < 1) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + cellRef + "'");
        }
        boolean bl2 = this.isRowAbs = rowRef.charAt(0) == '$';
        if (this.isRowAbs) {
            rowRef = rowRef.substring(1);
        }
        this.row = Integer.parseInt(rowRef) - 1;
    }

    public String getCellName() {
        StringBuilder sb = new StringBuilder(32);
        if (this.sheetName != null && !this.ignoreSheetNameInFormat) {
            CellRefUtil.appendFormat(sb, this.sheetName);
            sb.append('!');
        }
        this.appendCellReference(sb);
        return sb.toString();
    }

    public String getFormattedSheetName() {
        StringBuilder sb = new StringBuilder(32);
        CellRefUtil.appendFormat(sb, this.sheetName);
        return sb.toString();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public CellRef setSheetName(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public boolean isIgnoreSheetNameInFormat() {
        return this.ignoreSheetNameInFormat;
    }

    public CellRef setIgnoreSheetNameInFormat(boolean ignoreSheetNameInFormat) {
        this.ignoreSheetNameInFormat = ignoreSheetNameInFormat;
        return this;
    }

    StringBuilder appendCellReference(StringBuilder sb) {
        if (this.isColAbs) {
            sb.append('$');
        }
        sb.append(CellRefUtil.convertNumToColString(this.col));
        if (this.isRowAbs) {
            sb.append('$');
        }
        sb.append(this.row + 1);
        return sb;
    }

    public int getCol() {
        return this.col;
    }

    public CellRef setCol(int col) {
        this.col = col;
        return this;
    }

    public int getRow() {
        return this.row;
    }

    public CellRef setRow(int row) {
        this.row = row;
        return this;
    }

    public boolean isColAbs() {
        return this.isColAbs;
    }

    public CellRef setIsColAbs(boolean isColAbs) {
        this.isColAbs = isColAbs;
        return this;
    }

    public boolean isRowAbs() {
        return this.isRowAbs;
    }

    public CellRef setIsRowAbs(boolean isRowAbs) {
        this.isRowAbs = isRowAbs;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellRef cellRef = (CellRef)o;
        if (this.col != cellRef.col) {
            return false;
        }
        if (this.row != cellRef.row) {
            return false;
        }
        return !(this.sheetName != null ? !this.sheetName.equals(cellRef.sheetName) : cellRef.sheetName != null);
    }

    public int hashCode() {
        int result = this.col;
        result = 31 * result + this.row;
        result = 31 * result + (this.sheetName != null ? this.sheetName.hashCode() : 0);
        return result;
    }

    public String toString(boolean ignoreSheetName) {
        boolean currentIgnoreSheetValue = this.ignoreSheetNameInFormat;
        this.ignoreSheetNameInFormat = ignoreSheetName;
        String result = this.getCellName();
        this.ignoreSheetNameInFormat = currentIgnoreSheetValue;
        return result;
    }

    public boolean isValid() {
        return this.col >= 0 && this.row >= 0;
    }

    public String toString() {
        return this.getCellName();
    }

    @Override
    public int compareTo(CellRef that) {
        if (this == that) {
            return 0;
        }
        if (this.col < that.col) {
            return -1;
        }
        if (this.col > that.col) {
            return 1;
        }
        if (this.row < that.row) {
            return -1;
        }
        if (this.row > that.row) {
            return 1;
        }
        return 0;
    }
}

