/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.common;

import org.jxls.common.CellRef;
import org.jxls.common.cellshift.CellShiftStrategy;
import org.jxls.common.cellshift.InnerCellShiftStrategy;

public class CellRange {
    private CellShiftStrategy cellShiftStrategy = new InnerCellShiftStrategy();
    CellRef startCell;
    int width;
    int height;
    CellRef[][] cells;
    boolean[][] changeMatrix;
    int[] rowWidths;
    int[] colHeights;

    public CellRange(CellRef startCell, int width, int height) {
        String sheetName = startCell.getSheetName();
        this.startCell = startCell;
        this.width = width;
        this.height = height;
        this.cells = new CellRef[height][];
        this.changeMatrix = new boolean[height][];
        this.colHeights = new int[width];
        this.rowWidths = new int[height];
        for (int row = 0; row < height; ++row) {
            this.rowWidths[row] = width;
            this.cells[row] = new CellRef[width];
            this.changeMatrix[row] = new boolean[width];
            for (int col = 0; col < width; ++col) {
                this.cells[row][col] = new CellRef(sheetName, row, col);
            }
        }
        for (int col = 0; col < width; ++col) {
            this.colHeights[col] = height;
        }
    }

    public CellRef getCell(int row, int col) {
        return this.cells[row][col];
    }

    public CellShiftStrategy getCellShiftStrategy() {
        return this.cellShiftStrategy;
    }

    public void setCellShiftStrategy(CellShiftStrategy cellShiftStrategy) {
        this.cellShiftStrategy = cellShiftStrategy;
    }

    void setCell(int row, int col, CellRef cellRef) {
        this.cells[row][col] = cellRef;
    }

    public void shiftCellsWithRowBlock(int startRow, int endRow, int col, int colShift, boolean updateRowWidths) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                boolean requiresShifting = this.cellShiftStrategy.requiresColShifting(this.cells[i][j], startRow, endRow, col);
                if (!requiresShifting || this.changeMatrix[i][j]) continue;
                this.cells[i][j].setCol(this.cells[i][j].getCol() + colShift);
                this.changeMatrix[i][j] = true;
            }
        }
        int maxRow = Math.min(endRow, this.rowWidths.length - 1);
        int row = startRow;
        while (row <= maxRow) {
            int n = row++;
            this.rowWidths[n] = this.rowWidths[n] + colShift;
        }
    }

    public boolean requiresColShifting(CellRef cell, int startRow, int endRow, int startColShift) {
        return this.cellShiftStrategy.requiresColShifting(cell, startRow, endRow, startColShift);
    }

    public void shiftCellsWithColBlock(int startCol, int endCol, int row, int rowShift, boolean updateColHeights) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                boolean requiresShifting = this.cellShiftStrategy.requiresRowShifting(this.cells[i][j], startCol, endCol, row);
                if (!requiresShifting || this.changeMatrix[i][j]) continue;
                this.cells[i][j].setRow(this.cells[i][j].getRow() + rowShift);
                this.changeMatrix[i][j] = true;
            }
        }
        if (updateColHeights) {
            int maxCol = Math.min(endCol, this.colHeights.length - 1);
            int col = startCol;
            while (col <= maxCol) {
                int n = col++;
                this.colHeights[n] = this.colHeights[n] + rowShift;
            }
        }
    }

    public boolean requiresRowShifting(CellRef cell, int startCol, int endCol, int startRowShift) {
        return this.cellShiftStrategy.requiresRowShifting(cell, startCol, endCol, startRowShift);
    }

    public CellRef getStartCell() {
        return this.startCell;
    }

    public void excludeCells(int startCol, int endCol, int startRow, int endRow) {
        for (int row = startRow; row <= endRow; ++row) {
            for (int col = startCol; col <= endCol; ++col) {
                this.cells[row][col] = null;
            }
        }
    }

    public int calculateHeight() {
        int maxHeight = 0;
        for (int col = 0; col < this.width; ++col) {
            maxHeight = Math.max(maxHeight, this.colHeights[col]);
        }
        return maxHeight;
    }

    public int calculateWidth() {
        int maxWidth = 0;
        for (int row = 0; row < this.height; ++row) {
            maxWidth = Math.max(maxWidth, this.rowWidths[row]);
        }
        return maxWidth;
    }

    public boolean isExcluded(int row, int col) {
        return this.cells[row][col] == null;
    }

    public boolean hasChanged(int row, int col) {
        return this.changeMatrix[row][col];
    }

    public void resetChangeMatrix() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.changeMatrix[i][j] = false;
            }
        }
    }
}

