/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import org.jxls.area.Area;
import org.jxls.area.XlsArea;
import org.jxls.command.AbstractCommand;
import org.jxls.command.Command;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.util.Util;

public class IfCommand
extends AbstractCommand {
    private String condition;
    private Area ifArea = XlsArea.EMPTY_AREA;
    private Area elseArea = XlsArea.EMPTY_AREA;

    public IfCommand() {
    }

    public IfCommand(String condition) {
        this.condition = condition;
    }

    public IfCommand(String condition, Area ifArea, Area elseArea) {
        this.condition = condition;
        this.ifArea = ifArea != null ? ifArea : XlsArea.EMPTY_AREA;
        this.elseArea = elseArea != null ? elseArea : XlsArea.EMPTY_AREA;
        super.addArea(this.ifArea);
        super.addArea(this.elseArea);
    }

    public IfCommand(String condition, XlsArea ifArea) {
        this(condition, ifArea, XlsArea.EMPTY_AREA);
    }

    @Override
    public String getName() {
        return "if";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Area getIfArea() {
        return this.ifArea;
    }

    public Area getElseArea() {
        return this.elseArea;
    }

    @Override
    public Command addArea(Area area) {
        if (this.areaList.size() >= 2) {
            throw new IllegalArgumentException("Cannot add any more areas to this IfCommand. You can add only 1 area for 'if' part and 1 area for 'else' part");
        }
        if (this.areaList.isEmpty()) {
            this.ifArea = area;
        } else {
            this.elseArea = area;
        }
        return super.addArea(area);
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        Boolean conditionResult = Util.isConditionTrue(this.getTransformationConfig().getExpressionEvaluator(), this.condition, context);
        if (conditionResult.booleanValue()) {
            return this.ifArea.applyAt(cellRef, context);
        }
        return this.elseArea.applyAt(cellRef, context);
    }
}

