/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.area;

import java.util.ArrayList;
import java.util.List;
import org.jxls.area.Area;
import org.jxls.area.CommandData;
import org.jxls.command.Command;
import org.jxls.common.AreaListener;
import org.jxls.common.AreaRef;
import org.jxls.common.CellData;
import org.jxls.common.CellRange;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.common.cellshift.AdjacentCellShiftStrategy;
import org.jxls.common.cellshift.CellShiftStrategy;
import org.jxls.common.cellshift.InnerCellShiftStrategy;
import org.jxls.formula.FastFormulaProcessor;
import org.jxls.formula.FormulaProcessor;
import org.jxls.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsArea
implements Area {
    static Logger logger = LoggerFactory.getLogger(XlsArea.class);
    public static final XlsArea EMPTY_AREA = new XlsArea(new CellRef(null, 0, 0), Size.ZERO_SIZE);
    List<CommandData> commandDataList = new ArrayList<CommandData>();
    Transformer transformer;
    CellRange cellRange;
    CellRef startCellRef;
    Size size;
    List<AreaListener> areaListeners = new ArrayList<AreaListener>();
    private boolean cellsCleared = false;
    private FormulaProcessor formulaProcessor = new FastFormulaProcessor();
    private CellShiftStrategy cellShiftStrategy = new InnerCellShiftStrategy();
    private final CellShiftStrategy innerCellShiftStrategy = new InnerCellShiftStrategy();
    private final CellShiftStrategy adjacentCellShiftStrategy = new AdjacentCellShiftStrategy();

    public XlsArea(AreaRef areaRef, Transformer transformer) {
        CellRef startCell = areaRef.getFirstCellRef();
        CellRef endCell = areaRef.getLastCellRef();
        this.startCellRef = startCell;
        this.size = new Size(endCell.getCol() - startCell.getCol() + 1, endCell.getRow() - startCell.getRow() + 1);
        this.transformer = transformer;
    }

    public XlsArea(String areaRef, Transformer transformer) {
        this(new AreaRef(areaRef), transformer);
    }

    public XlsArea(CellRef startCell, CellRef endCell, Transformer transformer) {
        this(new AreaRef(startCell, endCell), transformer);
    }

    public XlsArea(CellRef startCellRef, Size size, List<CommandData> commandDataList, Transformer transformer) {
        this.startCellRef = startCellRef;
        this.size = size;
        this.commandDataList = commandDataList != null ? commandDataList : new ArrayList();
        this.transformer = transformer;
    }

    public XlsArea(CellRef startCellRef, Size size) {
        this(startCellRef, size, null, null);
    }

    public XlsArea(CellRef startCellRef, Size size, Transformer transformer) {
        this(startCellRef, size, null, transformer);
    }

    @Override
    public CellShiftStrategy getCellShiftStrategy() {
        return this.cellShiftStrategy;
    }

    @Override
    public void setCellShiftStrategy(CellShiftStrategy cellShiftStrategy) {
        this.cellShiftStrategy = cellShiftStrategy;
    }

    @Override
    public FormulaProcessor getFormulaProcessor() {
        return this.formulaProcessor;
    }

    @Override
    public void setFormulaProcessor(FormulaProcessor formulaProcessor) {
        this.formulaProcessor = formulaProcessor;
    }

    @Override
    public void addCommand(AreaRef areaRef, Command command) {
        AreaRef thisAreaRef = new AreaRef(this.startCellRef, this.size);
        if (!thisAreaRef.contains(areaRef)) {
            throw new IllegalArgumentException("Cannot add command '" + command.getName() + "' to area " + thisAreaRef + " at " + areaRef);
        }
        this.commandDataList.add(new CommandData(areaRef, command));
    }

    public void addCommand(String areaRef, Command command) {
        this.commandDataList.add(new CommandData(areaRef, command));
    }

    @Override
    public List<CommandData> getCommandDataList() {
        return this.commandDataList;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    private void createCellRange() {
        this.cellRange = new CellRange(this.startCellRef, this.size.getWidth(), this.size.getHeight());
        for (CommandData commandData : this.commandDataList) {
            CellRef startCellRef = commandData.getSourceStartCellRef();
            Size size = commandData.getSourceSize();
            this.cellRange.excludeCells(startCellRef.getCol() - this.startCellRef.getCol(), startCellRef.getCol() - this.startCellRef.getCol() + size.getWidth() - 1, startCellRef.getRow() - this.startCellRef.getRow(), startCellRef.getRow() - this.startCellRef.getRow() + size.getHeight() - 1);
        }
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        logger.debug("Applying XlsArea at {}", (Object)cellRef);
        this.fireBeforeApplyEvent(cellRef, context);
        this.createCellRange();
        int topStaticAreaLastRow = this.transformTopStaticArea(cellRef, context);
        for (int i = 0; i < this.commandDataList.size(); ++i) {
            this.cellRange.resetChangeMatrix();
            CommandData commandData = this.commandDataList.get(i);
            String shiftMode = commandData.getCommand().getShiftMode();
            CellShiftStrategy commandCellShiftStrategy = this.detectCellShiftStrategy(shiftMode);
            this.cellRange.setCellShiftStrategy(commandCellShiftStrategy);
            CellRef commandStartCellRef = commandData.getStartCellRef();
            Size commandInitialSize = commandData.getSize();
            CellRef newCell = new CellRef(cellRef.getSheetName(), commandStartCellRef.getRow() - this.startCellRef.getRow() + cellRef.getRow(), commandStartCellRef.getCol() - this.startCellRef.getCol() + cellRef.getCol());
            Size commandNewSize = commandData.getCommand().applyAt(newCell, context);
            int widthChange = commandNewSize.getWidth() - commandInitialSize.getWidth();
            int heightChange = commandNewSize.getHeight() - commandInitialSize.getHeight();
            if (widthChange == 0 && heightChange == 0) continue;
            if (widthChange != 0) {
                this.cellRange.shiftCellsWithRowBlock(commandStartCellRef.getRow() - this.startCellRef.getRow(), commandStartCellRef.getRow() - this.startCellRef.getRow() + commandData.getSize().getHeight(), commandStartCellRef.getCol() - this.startCellRef.getCol() + commandInitialSize.getWidth() - 1, widthChange, true);
            }
            if (heightChange != 0) {
                this.cellRange.shiftCellsWithColBlock(commandStartCellRef.getCol() - this.startCellRef.getCol(), commandStartCellRef.getCol() - this.startCellRef.getCol() + commandNewSize.getWidth() - 1, commandStartCellRef.getRow() - this.startCellRef.getRow() + commandData.getSize().getHeight() - 1, heightChange, true);
            }
            for (int j = i + 1; j < this.commandDataList.size(); ++j) {
                CommandData data = this.commandDataList.get(j);
                CellRef commandDataStartCellRef = data.getStartCellRef();
                int newRow = commandDataStartCellRef.getRow() - this.startCellRef.getRow() + cellRef.getRow();
                int newCol = commandDataStartCellRef.getCol() - this.startCellRef.getCol() + cellRef.getCol();
                Size commandDataSize = data.getSize();
                if (newRow > newCell.getRow() && (newCol >= newCell.getCol() && newCol <= newCell.getCol() + commandNewSize.getWidth() || newCol + commandDataSize.getWidth() >= newCell.getCol() && newCol + commandDataSize.getWidth() <= newCell.getCol() + commandNewSize.getWidth() || newCell.getCol() >= newCol && newCell.getCol() <= newCol + commandDataSize.getWidth())) {
                    this.cellRange.shiftCellsWithColBlock(commandDataStartCellRef.getCol() - this.startCellRef.getCol(), commandDataStartCellRef.getCol() - this.startCellRef.getCol() + commandDataSize.getWidth() - 1, commandDataStartCellRef.getRow() - this.startCellRef.getRow() + commandDataSize.getHeight() - 1, heightChange, false);
                    data.setStartCellRef(new CellRef(commandDataStartCellRef.getSheetName(), commandDataStartCellRef.getRow() + heightChange, commandDataStartCellRef.getCol()));
                    continue;
                }
                if (newCol <= newCell.getCol() || !(newRow >= newCell.getRow() && newRow <= newCell.getRow() + commandNewSize.getHeight() || newRow + commandDataSize.getHeight() >= newCell.getRow() && newRow + commandDataSize.getHeight() <= newCell.getRow() + commandNewSize.getHeight()) && (newCell.getRow() < newRow || newCell.getRow() > newRow + commandDataSize.getHeight())) continue;
                this.cellRange.shiftCellsWithRowBlock(commandDataStartCellRef.getRow() - this.startCellRef.getRow(), commandDataStartCellRef.getRow() - this.startCellRef.getRow() + commandDataSize.getHeight() - 1, commandDataStartCellRef.getCol() - this.startCellRef.getCol() + commandInitialSize.getWidth(), widthChange, false);
                data.setStartCellRef(new CellRef(commandDataStartCellRef.getSheetName(), commandDataStartCellRef.getRow(), commandDataStartCellRef.getCol() + widthChange));
            }
        }
        this.transformStaticCells(cellRef, context, topStaticAreaLastRow + 1);
        this.fireAfterApplyEvent(cellRef, context);
        Size finalSize = new Size(this.cellRange.calculateWidth(), this.cellRange.calculateHeight());
        AreaRef newAreaRef = new AreaRef(cellRef, finalSize);
        this.updateCellDataFinalAreaForFormulaCells(newAreaRef);
        for (CommandData commandData : this.commandDataList) {
            commandData.resetStartCellAndSize();
        }
        return finalSize;
    }

    private CellShiftStrategy detectCellShiftStrategy(String shiftMode) {
        if (shiftMode != null && "adjacent".equalsIgnoreCase(shiftMode)) {
            return this.adjacentCellShiftStrategy;
        }
        return this.innerCellShiftStrategy;
    }

    private void updateCellDataFinalAreaForFormulaCells(AreaRef newAreaRef) {
        String sheetName = this.startCellRef.getSheetName();
        int offsetRow = this.startCellRef.getRow();
        int startCol = this.startCellRef.getCol();
        for (int col = 0; col < this.size.getWidth(); ++col) {
            for (int row = 0; row < this.size.getHeight(); ++row) {
                CellRef srcCell;
                CellData cellData;
                if (this.cellRange.isExcluded(row, col) || (cellData = this.transformer.getCellData(srcCell = new CellRef(sheetName, offsetRow + row, startCol + col))) == null || !cellData.isFormulaCell()) continue;
                cellData.addTargetParentAreaRef(newAreaRef);
            }
        }
    }

    private int transformTopStaticArea(CellRef cellRef, Context context) {
        String sheetName = this.startCellRef.getSheetName();
        int startRow = this.startCellRef.getRow();
        int startCol = this.startCellRef.getCol();
        int topStaticAreaLastRow = this.findRelativeTopCommandRow() - 1;
        for (int col = 0; col < this.size.getWidth(); ++col) {
            for (int row = 0; row <= topStaticAreaLastRow; ++row) {
                if (this.cellRange.isExcluded(row, col)) continue;
                CellRef relativeCell = this.cellRange.getCell(row, col);
                CellRef srcCell = new CellRef(sheetName, startRow + row, startCol + col);
                CellRef targetCell = new CellRef(cellRef.getSheetName(), relativeCell.getRow() + cellRef.getRow(), relativeCell.getCol() + cellRef.getCol());
                this.fireBeforeTransformCell(srcCell, targetCell, context);
                try {
                    this.updateCellDataArea(srcCell, targetCell, context);
                    this.transformer.transform(srcCell, targetCell, context);
                }
                catch (Exception e) {
                    logger.error("Failed to transform " + srcCell + " into " + targetCell, (Throwable)e);
                }
                this.fireAfterTransformCell(srcCell, targetCell, context);
            }
        }
        return topStaticAreaLastRow;
    }

    private int findRelativeTopCommandRow() {
        int topCommandRow = this.startCellRef.getRow() + this.size.getHeight() - 1;
        for (CommandData data : this.commandDataList) {
            topCommandRow = Math.min(data.getStartCellRef().getRow(), topCommandRow);
        }
        return topCommandRow - this.startCellRef.getRow();
    }

    private void fireBeforeApplyEvent(CellRef cellRef, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.beforeApplyAtCell(cellRef, context);
        }
    }

    private void fireAfterApplyEvent(CellRef cellRef, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.afterApplyAtCell(cellRef, context);
        }
    }

    public void clearCells() {
        if (this.cellsCleared) {
            return;
        }
        String sheetName = this.startCellRef.getSheetName();
        int startRow = this.startCellRef.getRow();
        int startCol = this.startCellRef.getCol();
        for (int row = 0; row < this.size.getHeight(); ++row) {
            for (int col = 0; col < this.size.getWidth(); ++col) {
                CellRef cellRef = new CellRef(sheetName, startRow + row, startCol + col);
                this.transformer.clearCell(cellRef);
            }
        }
        this.transformer.resetArea(this.getAreaRef());
        this.cellsCleared = true;
    }

    private void transformStaticCells(CellRef cellRef, Context context, int relativeStartRow) {
        String sheetName = this.startCellRef.getSheetName();
        int offsetRow = this.startCellRef.getRow();
        int startCol = this.startCellRef.getCol();
        for (int col = 0; col < this.size.getWidth(); ++col) {
            for (int row = relativeStartRow; row < this.size.getHeight(); ++row) {
                if (this.cellRange.isExcluded(row, col)) continue;
                CellRef relativeCell = this.cellRange.getCell(row, col);
                CellRef srcCell = new CellRef(sheetName, offsetRow + row, startCol + col);
                CellRef targetCell = new CellRef(cellRef.getSheetName(), relativeCell.getRow() + cellRef.getRow(), relativeCell.getCol() + cellRef.getCol());
                this.fireBeforeTransformCell(srcCell, targetCell, context);
                try {
                    this.updateCellDataArea(srcCell, targetCell, context);
                    this.transformer.transform(srcCell, targetCell, context);
                }
                catch (Exception e) {
                    logger.error("Failed to transform " + srcCell + " into " + targetCell, (Throwable)e);
                }
                this.fireAfterTransformCell(srcCell, targetCell, context);
            }
        }
    }

    private void updateCellDataArea(CellRef srcCell, CellRef targetCell, Context context) {
        Context.Config config = context.getConfig();
        if (!config.isFormulaProcessingRequired()) {
            return;
        }
        CellData cellData = this.transformer.getCellData(srcCell);
        if (cellData != null) {
            cellData.setArea(this);
            cellData.addTargetPos(targetCell);
        }
    }

    private void fireBeforeTransformCell(CellRef srcCell, CellRef targetCell, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.beforeTransformCell(srcCell, targetCell, context);
        }
    }

    private void fireAfterTransformCell(CellRef srcCell, CellRef targetCell, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.afterTransformCell(srcCell, targetCell, context);
        }
    }

    @Override
    public CellRef getStartCellRef() {
        return this.startCellRef;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public AreaRef getAreaRef() {
        return new AreaRef(this.startCellRef, this.size);
    }

    @Override
    public void processFormulas() {
        this.formulaProcessor.processAreaFormulas(this.transformer);
    }

    @Override
    public void addAreaListener(AreaListener listener) {
        this.areaListeners.add(listener);
    }

    @Override
    public List<AreaListener> getAreaListeners() {
        return this.areaListeners;
    }

    @Override
    public List<Command> findCommandByName(String name) {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (CommandData commandData : this.commandDataList) {
            if (name == null || !name.equals(commandData.getCommand().getName())) continue;
            commands.add(commandData.getCommand());
        }
        return commands;
    }

    @Override
    public void reset() {
        for (CommandData commandData : this.commandDataList) {
            commandData.reset();
        }
        this.transformer.resetTargetCellRefs();
    }
}

