/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.area;

import org.jxls.command.Command;
import org.jxls.common.AreaRef;
import org.jxls.common.CellRef;
import org.jxls.common.Size;

public class CommandData {
    private CellRef sourceStartCellRef;
    private Size sourceSize;
    CellRef startCellRef;
    Size size;
    Command command;

    public CommandData(AreaRef areaRef, Command command) {
        this.startCellRef = areaRef.getFirstCellRef();
        this.size = areaRef.getSize();
        this.command = command;
        this.sourceStartCellRef = this.startCellRef;
        this.sourceSize = this.size;
    }

    public CommandData(String areaRef, Command command) {
        this(new AreaRef(areaRef), command);
    }

    public CommandData(CellRef startCellRef, Size size, Command command) {
        this.startCellRef = startCellRef;
        this.size = size;
        this.command = command;
    }

    public AreaRef getAreaRef() {
        return new AreaRef(this.startCellRef, this.size);
    }

    public CellRef getStartCellRef() {
        return this.startCellRef;
    }

    public Size getSize() {
        return this.size;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setStartCellRef(CellRef startCellRef) {
        this.startCellRef = startCellRef;
    }

    public CellRef getSourceStartCellRef() {
        return this.sourceStartCellRef;
    }

    public void setSourceStartCellRef(CellRef sourceStartCellRef) {
        this.sourceStartCellRef = sourceStartCellRef;
    }

    public Size getSourceSize() {
        return this.sourceSize;
    }

    public void setSourceSize(Size sourceSize) {
        this.sourceSize = sourceSize;
    }

    void reset() {
        this.startCellRef = this.sourceStartCellRef;
        this.size = this.sourceSize;
        this.command.reset();
    }

    void resetStartCellAndSize() {
        this.startCellRef = this.sourceStartCellRef;
        this.size = this.sourceSize;
    }
}

