/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class JxlsNationalLanguageSupport {
    private String start = "R{";
    private String end = "}";
    private String defaultValueDelimiter = "=";
    private Pattern pattern;

    public File process(InputStream in) {
        try {
            File out = File.createTempFile("JXLS-R-", ".xlsx");
            this.process(in, new FileOutputStream(out));
            return out;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void process(InputStream in, OutputStream out) throws IOException, TransformerConfigurationException, ParserConfigurationException, SAXException, TransformerException, TransformerFactoryConfigurationError {
        this.pattern = Pattern.compile(Pattern.quote(this.start) + "(.*?)" + Pattern.quote(this.end));
        try (ZipInputStream zipin = new ZipInputStream(in);
             ZipOutputStream zipout = new ZipOutputStream(out);){
            ZipEntry zipEntry;
            while ((zipEntry = zipin.getNextEntry()) != null) {
                this.processZipEntry(zipEntry, zipin, zipout);
            }
        }
        this.pattern = null;
    }

    protected void processZipEntry(ZipEntry zipEntry, InputStream in, ZipOutputStream zipout) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        zipout.putNextEntry(new ZipEntry(zipEntry.getName()));
        if (zipEntry.getName().toLowerCase().endsWith(".xml")) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            Document dom = builder.parse(this.getNoCloseInputStream(in));
            this.processElement(dom.getDocumentElement());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            transformerFactory.newTransformer().transform(new DOMSource(dom), new StreamResult(zipout));
        } else {
            this.transfer(in, zipout);
        }
        zipout.closeEntry();
    }

    private InputStream getNoCloseInputStream(final InputStream in) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return in.read();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    private void processElement(Element root) {
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String newValue;
            String val;
            Node item = attributes.item(i);
            if (!(item instanceof Attr) || (val = ((Attr)item).getValue()).equals(newValue = this.translateAll(val))) continue;
            ((Attr)item).setValue(newValue);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node item = children.item(i);
            if (item instanceof Text) {
                String newValue;
                String val = ((Text)item).getTextContent();
                if (val.equals(newValue = this.translateAll(val))) continue;
                item.setTextContent(newValue);
                continue;
            }
            if (!(item instanceof Element)) continue;
            this.processElement((Element)item);
        }
    }

    protected String translateAll(String text) {
        StringBuffer ret = new StringBuffer();
        Matcher matcher = this.pattern.matcher(text);
        while (matcher.find()) {
            String name;
            String fallback = name = matcher.group(1);
            int o = name.indexOf(this.defaultValueDelimiter);
            if (o > 0) {
                fallback = name.substring(o + this.defaultValueDelimiter.length());
                name = name.substring(0, o);
            }
            String newValue = this.translate(name.trim(), fallback);
            matcher.appendReplacement(ret, newValue);
        }
        matcher.appendTail(ret);
        return ret.toString();
    }

    protected abstract String translate(String var1, String var2);

    protected void transfer(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getDefaultValueDelimiter() {
        return this.defaultValueDelimiter;
    }

    public void setDefaultValueDelimiter(String defaultValueDelimiter) {
        this.defaultValueDelimiter = defaultValueDelimiter;
    }
}

