/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jxls.common.JxlsException;
import org.jxls.transform.Transformer;
import org.jxls.util.CannotOpenWorkbookException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerFactory {
    public static final String POI_CLASS_NAME = "org.jxls.transform.poi.PoiTransformer";
    public static final String INIT_METHOD = "createTransformer";
    public static final String TRANSFORMER_SYSTEM_PROPERTY = "jxlstransformer";
    public static final String POI_TRANSFORMER = "poi";
    private static Logger logger = LoggerFactory.getLogger(TransformerFactory.class);

    public static Transformer createTransformer(InputStream inputStream, OutputStream outputStream) {
        Class<?> transformer = TransformerFactory.getTransformerClass();
        if (transformer == null) {
            logger.error("Cannot load any Transformer class. Please make sure you have necessary libraries in CLASSPATH.");
            return null;
        }
        logger.debug("Transformer class is " + transformer.getName());
        try {
            Method initMethod = transformer.getMethod(INIT_METHOD, InputStream.class, OutputStream.class);
            return (Transformer)initMethod.invoke(null, inputStream, outputStream);
        }
        catch (NoSuchMethodException e) {
            logger.error("The specified public method createTransformer does not exist in " + transformer.getName());
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CannotOpenWorkbookException) {
                throw (CannotOpenWorkbookException)e.getCause();
            }
            logger.error("Method createTransformer of " + transformer.getName() + " class thrown an Exception", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error("Method createTransformer of " + transformer.getName() + " is inaccessible", (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            logger.error("Failed to execute method createTransformer of " + transformer.getName(), (Throwable)e);
            return null;
        }
    }

    public static String getTransformerName() {
        Class<?> transformerClass = TransformerFactory.getTransformerClass();
        if (transformerClass == null) {
            return null;
        }
        if (POI_CLASS_NAME.equalsIgnoreCase(transformerClass.getName())) {
            return POI_TRANSFORMER;
        }
        return transformerClass.getName();
    }

    public static String getTransformerClassName() {
        String transformerClassName = System.getProperty(TRANSFORMER_SYSTEM_PROPERTY, POI_CLASS_NAME);
        if (transformerClassName.equalsIgnoreCase(POI_TRANSFORMER)) {
            transformerClassName = POI_CLASS_NAME;
        }
        return transformerClassName;
    }

    private static Class<?> getTransformerClass() {
        String transformerClassName = TransformerFactory.getTransformerClassName();
        return TransformerFactory.loadTransformerByClass(transformerClassName);
    }

    private static Class<?> loadTransformerByClass(String transformerClassName) {
        try {
            logger.info("Loading transformer by class {}", (Object)transformerClassName);
            return Class.forName(transformerClassName);
        }
        catch (Exception e) {
            logger.error("Failed to load transformer class", (Throwable)e);
            throw new JxlsException("Failed to load transformer class " + transformerClassName, e);
        }
    }
}

