/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.functions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.jxls.common.Context;
import org.jxls.expression.JexlExpressionEvaluator;
import org.jxls.functions.Summarizer;
import org.jxls.functions.SummarizerBuilder;

public class GroupSum<T> {
    private final Context context;
    private final SummarizerBuilder<T> sumBuilder;

    public GroupSum(Context context, SummarizerBuilder<T> sumBuilder) {
        this.context = context;
        this.sumBuilder = sumBuilder;
    }

    public T sum(String fieldName, String expression) {
        return this.sum(fieldName, this.getItems(expression));
    }

    public T sum(String fieldName, Collection<Object> collection) {
        Summarizer<T> sum = this.sumBuilder.build();
        for (Object i : collection) {
            sum.add(this.getValue(i, fieldName));
        }
        return sum.getSum();
    }

    private Object getValue(Object i, String fieldName) {
        if (i instanceof Map) {
            Map map = (Map)i;
            if (!map.containsKey(fieldName)) {
                throw new RuntimeException("Attribute " + fieldName + " does not exist in collection element!");
            }
            return map.get(fieldName);
        }
        try {
            return PropertyUtils.getProperty((Object)i, (String)fieldName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<Object> getItems(String expression) {
        Object result = this.getValue(expression);
        if (result == null) {
            throw new NullPointerException("\"" + expression + "\" is null!");
        }
        if (!(result instanceof Collection)) {
            throw new ClassCastException(expression + " is not a Collection!");
        }
        return (Collection)result;
    }

    private Object getValue(String expression) {
        return new JexlExpressionEvaluator(expression).evaluate(this.context.toMap());
    }
}

