/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.vintage;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junitpioneer.vintage.Test;

class TimeoutExtension
implements InvocationInterceptor {
    static final String TEST_RAN_TOO_LONG = "Test '%s' was supposed to run no longer than %d ms.";

    TimeoutExtension() {
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Optional<Long> optionalTimeout = this.annotatedTimeout(extensionContext);
        if (optionalTimeout.isPresent()) {
            this.proceedWithTimeout(invocation, extensionContext, optionalTimeout.get());
        } else {
            invocation.proceed();
        }
    }

    private void proceedWithTimeout(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext, long timeout) {
        if (timeout < 0L) {
            throw new ExtensionConfigurationException("Timeout for vintage @Test must be positive.");
        }
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(timeout), () -> invocation.proceed(), (String)String.format(TEST_RAN_TOO_LONG, extensionContext.getDisplayName(), timeout));
    }

    private Optional<Long> annotatedTimeout(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), Test.class).map(Test::timeout).filter(timeout -> timeout != 0L);
    }
}

