/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.vintage;

import java.util.Optional;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junitpioneer.vintage.Test;
import org.opentest4j.AssertionFailedError;

class ExpectedExceptionExtension
implements TestExecutionExceptionHandler,
AfterTestExecutionCallback {
    static final String EXPECTED_EXCEPTION_WAS_NOT_THROWN = "Expected exception %s was not thrown.";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ExpectedExceptionExtension.class});
    private static final String KEY = "ExceptionWasThrown";

    ExpectedExceptionExtension() {
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        boolean throwableMatchesExpectedException = ExpectedExceptionExtension.expectedException(context).filter(expected -> expected.isInstance(throwable)).isPresent();
        if (!throwableMatchesExpectedException) {
            ExpectedExceptionExtension.storeExceptionStatus(context, EXCEPTION.WAS_THROWN_NOT_AS_EXPECTED);
            throw throwable;
        }
        ExpectedExceptionExtension.storeExceptionStatus(context, EXCEPTION.WAS_THROWN_AS_EXPECTED);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        switch (ExpectedExceptionExtension.loadExceptionStatus(context)) {
            case WAS_NOT_THROWN: {
                ExpectedExceptionExtension.expectedException(context).map(expected -> new AssertionFailedError(String.format(EXPECTED_EXCEPTION_WAS_NOT_THROWN, expected))).ifPresent(error -> {
                    throw error;
                });
            }
            case WAS_THROWN_AS_EXPECTED: {
                break;
            }
            case WAS_THROWN_NOT_AS_EXPECTED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid exceptionStatus");
            }
        }
    }

    private static Optional<? extends Class<? extends Throwable>> expectedException(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), Test.class).map(Test::expected).filter(exceptionType -> exceptionType != Test.None.class);
    }

    private static void storeExceptionStatus(ExtensionContext context, EXCEPTION thrown) {
        context.getStore(NAMESPACE).put((Object)KEY, (Object)thrown);
    }

    private static EXCEPTION loadExceptionStatus(ExtensionContext context) {
        EXCEPTION thrown = (EXCEPTION)((Object)context.getStore(NAMESPACE).get((Object)KEY, EXCEPTION.class));
        if (thrown == null) {
            return EXCEPTION.WAS_NOT_THROWN;
        }
        return thrown;
    }

    private static enum EXCEPTION {
        WAS_NOT_THROWN,
        WAS_THROWN_AS_EXPECTED,
        WAS_THROWN_NOT_AS_EXPECTED;

    }
}

