/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.params;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.jupiter.CartesianAnnotationConsumer;
import org.junitpioneer.jupiter.cartesian.CartesianParameterArgumentsProvider;
import org.junitpioneer.jupiter.params.Range;
import org.junitpioneer.jupiter.params.RangeClass;

class RangeSourceArgumentsProvider<N extends Number>
implements ArgumentsProvider,
CartesianAnnotationConsumer<Annotation>,
CartesianParameterArgumentsProvider<N> {
    private Annotation argumentsSource;

    RangeSourceArgumentsProvider() {
    }

    @Override
    public Stream<N> provideArguments(ExtensionContext context, Parameter parameter) throws Exception {
        this.initArgumentsSource(parameter);
        return this.provideArguments(this.argumentsSource);
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        if (this.argumentsSource == null) {
            this.initArgumentsSource(context.getRequiredTestMethod());
        }
        return this.provideArguments(this.argumentsSource).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private Stream<N> provideArguments(Annotation argumentsSource) throws Exception {
        Class<? extends Annotation> argumentsSourceClass = argumentsSource.annotationType();
        Class<? extends Range> rangeClass = argumentsSourceClass.getAnnotation(RangeClass.class).value();
        Range range = (Range)rangeClass.getConstructors()[0].newInstance(argumentsSource);
        range.validate();
        return this.asStream(range);
    }

    private void initArgumentsSource(AnnotatedElement element) {
        List<Annotation> argumentsSources = PioneerAnnotationUtils.findAnnotatedAnnotations(element, ArgumentsSource.class);
        if (argumentsSources.size() != 1) {
            String message = String.format("Expected exactly one annotation to provide an ArgumentSource, found %d.", argumentsSources.size());
            throw new IllegalArgumentException(message);
        }
        this.argumentsSource = argumentsSources.get(0);
    }

    private Stream<N> asStream(Range<N> range) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(range, 16), false);
    }

    @Override
    public void accept(Annotation argumentsSource) {
        this.argumentsSource = argumentsSource;
    }
}

