/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.params;

import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class Range<N extends Number>
implements Iterator<N> {
    private N from;
    private N to;
    private N step;
    private boolean closed;
    private N current;
    private int sign;
    private N zero;

    Range(N from, N to, N step, boolean closed, N zero) {
        this.from = from;
        this.to = to;
        this.step = step;
        this.closed = closed;
        this.zero = zero;
        this.current = null;
        this.sign = ((Comparable)step).compareTo(this.getZero());
    }

    void validate() {
        boolean fromNotEqualsTo;
        if (this.step.equals(this.getZero())) {
            throw new IllegalArgumentException("Illegal range. The step cannot be zero.");
        }
        if (!this.closed && this.from.equals(this.to)) {
            throw new IllegalArgumentException("Illegal range. Equal from and to will produce an empty range.");
        }
        boolean bl = fromNotEqualsTo = ((Comparable)this.from).compareTo(this.to) != 0;
        if (this.isValidDescending() && (!this.closed || fromNotEqualsTo)) {
            String message = String.format("Illegal range. There's no way to get from %s to %s with a step of %s.", this.from, this.to, this.step);
            throw new IllegalArgumentException(message);
        }
    }

    boolean isValidDescending() {
        boolean fromIsLessThanTo = ((Comparable)this.from).compareTo(this.to) < 0;
        boolean stepIsLessThanZero = this.sign < 0;
        return fromIsLessThanTo == stepIsLessThanZero;
    }

    N getStep() {
        return this.step;
    }

    N getCurrent() {
        return this.current;
    }

    abstract N nextValue();

    private N getNextValue() {
        if (this.current == null) {
            return this.from;
        }
        return this.nextValue();
    }

    private N getZero() {
        return this.zero;
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            return true;
        }
        N nextValue = this.getNextValue();
        int cmp = ((Comparable)nextValue).compareTo(this.to);
        int overflowCheck = ((Comparable)nextValue).compareTo(this.current);
        return cmp < 0 != this.sign < 0 && overflowCheck < 0 == this.sign < 0 || this.closed && cmp == 0;
    }

    @Override
    public N next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.getNextValue();
        return this.current;
    }
}

