/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.params;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.jupiter.params.DisableIfDisplayName;

class DisableIfNameExtension
implements ExecutionCondition {
    DisableIfNameExtension() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        if (!context.getUniqueId().contains("test-template-invocation")) {
            return ConditionEvaluationResult.enabled((String)"Never disable parameterized test method itself");
        }
        return PioneerAnnotationUtils.findClosestEnclosingAnnotation(context, DisableIfDisplayName.class).map(annotation -> this.disable(context, (DisableIfDisplayName)annotation)).orElseGet(() -> ConditionEvaluationResult.enabled((String)"No instructions to disable"));
    }

    private ConditionEvaluationResult disable(ExtensionContext context, DisableIfDisplayName annotation) {
        boolean checkRegExps;
        String[] substrings = annotation.contains();
        String[] regExps = annotation.matches();
        boolean checkSubstrings = substrings.length > 0;
        boolean bl = checkRegExps = regExps.length > 0;
        if (checkRegExps == checkSubstrings) {
            throw new ExtensionConfigurationException(String.format("%s %s.", "@DisableIfDisplayName requires that either `contains` or `matches` is specified, but both are", checkSubstrings ? "present" : "empty"));
        }
        String displayName = context.getDisplayName();
        if (checkSubstrings) {
            return this.disableIfContains(displayName, substrings);
        }
        return this.disableIfMatches(displayName, regExps);
    }

    private ConditionEvaluationResult disableIfContains(String displayName, String[] substrings) {
        String matches = Stream.of(substrings).filter(displayName::contains).collect(Collectors.joining("', '"));
        return matches.isEmpty() ? ConditionEvaluationResult.enabled((String)DisableIfNameExtension.reason(displayName, "doesn't contain any substring.")) : ConditionEvaluationResult.disabled((String)DisableIfNameExtension.reason(displayName, String.format("contains '%s'.", matches)));
    }

    private ConditionEvaluationResult disableIfMatches(String displayName, String[] regExps) {
        String matches = Stream.of(regExps).filter(displayName::matches).collect(Collectors.joining("', '"));
        return matches.isEmpty() ? ConditionEvaluationResult.enabled((String)DisableIfNameExtension.reason(displayName, "doesn't match any regular expression.")) : ConditionEvaluationResult.disabled((String)DisableIfNameExtension.reason(displayName, String.format("matches '%s'.", matches)));
    }

    private static String reason(String displayName, String outcome) {
        return String.format("Display name '%s' %s", displayName, outcome);
    }
}

