/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.params;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junitpioneer.jupiter.params.DisableIfAllArguments;
import org.junitpioneer.jupiter.params.DisableIfAnyArgument;
import org.junitpioneer.jupiter.params.DisableIfArgument;
import org.opentest4j.TestAbortedException;

class DisableIfArgumentExtension
implements InvocationInterceptor {
    DisableIfArgumentExtension() {
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Method testMethod = extensionContext.getRequiredTestMethod();
        List arguments = invocationContext.getArguments();
        if (arguments.isEmpty()) {
            throw new ExtensionConfigurationException(String.format("Can't disable based on arguments, because method %s had no parameters.", testMethod.getName()));
        }
        DisableIfArgumentExtension.checkRequiredAnnotations(testMethod);
        AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, DisableIfAllArguments.class).ifPresent(allParams -> {
            DisableIfArgumentExtension.verifyNonEmptyInputs(allParams);
            ArgumentChecker.checkAll(arguments).matches(allParams.matches());
            ArgumentChecker.checkAll(arguments).contains(allParams.contains());
        });
        AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, DisableIfAnyArgument.class).ifPresent(anyParam -> {
            DisableIfArgumentExtension.verifyNonEmptyInputs(anyParam);
            ArgumentChecker.checkAny(arguments).matches(anyParam.matches());
            ArgumentChecker.checkAny(arguments).contains(anyParam.contains());
        });
        List annotations = AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)testMethod, DisableIfArgument.class);
        for (int i = 0; i < annotations.size(); ++i) {
            DisableIfArgument parameter = (DisableIfArgument)annotations.get(i);
            DisableIfArgumentExtension.verifyNonEmptyInputs(parameter);
            Object argument = this.findArgument(testMethod, arguments, parameter, i);
            ArgumentChecker.check(argument).matches(parameter.matches());
            ArgumentChecker.check(argument).contains(parameter.contains());
        }
        invocation.proceed();
    }

    private static void checkRequiredAnnotations(Method testMethod) {
        if (!AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, DisableIfAnyArgument.class).isPresent() && !AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, DisableIfAllArguments.class).isPresent() && AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)testMethod, DisableIfArgument.class).isEmpty()) {
            throw new ExtensionConfigurationException("Required at least one of the following: @DisableIfArgument, @DisableIfAllArguments, @DisableIfAnyArgument but found none.");
        }
    }

    private static DisableIfAllArguments verifyNonEmptyInputs(DisableIfAllArguments annotation) {
        if (annotation.contains().length > 0 == annotation.matches().length > 0) {
            throw DisableIfArgumentExtension.invalidInputs(DisableIfAllArguments.class);
        }
        return annotation;
    }

    private static DisableIfAnyArgument verifyNonEmptyInputs(DisableIfAnyArgument annotation) {
        if (annotation.contains().length > 0 == annotation.matches().length > 0) {
            throw DisableIfArgumentExtension.invalidInputs(DisableIfAnyArgument.class);
        }
        return annotation;
    }

    private static DisableIfArgument verifyNonEmptyInputs(DisableIfArgument annotation) {
        if (annotation.contains().length > 0 == annotation.matches().length > 0) {
            throw DisableIfArgumentExtension.invalidInputs(DisableIfArgument.class);
        }
        return annotation;
    }

    private static RuntimeException invalidInputs(Class<?> annotationClass) {
        return new ExtensionConfigurationException(String.format("%s requires that either `contains` or `matches` is set.", annotationClass.getSimpleName()));
    }

    private Object findArgument(Method testMethod, List<Object> arguments, DisableIfArgument annotation, int index) {
        if (!annotation.name().isEmpty() && annotation.index() > -1) {
            throw new ExtensionConfigurationException("Using both name and index parameter targeting in a single @DisableIfArgument is not permitted.");
        }
        if (!annotation.name().isEmpty()) {
            if (testMethod.getParameters()[0].isNamePresent()) {
                return this.findArgumentByName(testMethod, arguments, annotation.name());
            }
            throw new ParameterResolutionException(String.format("%s: Could not resolve parameter by name (%s).", testMethod.getName(), annotation.name()));
        }
        if (annotation.index() > -1) {
            return this.findArgumentByIndex(arguments, annotation.index());
        }
        return arguments.get(index);
    }

    private Object findArgumentByName(Method testMethod, List<Object> arguments, String name) {
        return arguments.get(this.findParameterIndexFromName(testMethod, name));
    }

    private int findParameterIndexFromName(Method testMethod, String name) {
        Parameter[] parameters = testMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getName().equals(name)) continue;
            return i;
        }
        throw new ParameterResolutionException(String.format("Could not find parameter named %s in test %s", name, testMethod));
    }

    private Object findArgumentByIndex(List<Object> arguments, int index) {
        this.verifyValidIndex(arguments, index);
        return arguments.get(index);
    }

    private void verifyValidIndex(List<Object> arguments, int index) {
        if (index > arguments.size()) {
            throw new ExtensionConfigurationException(String.format("Annotation has invalid index [%s], should be less than %s", index, arguments.size()));
        }
    }

    private static class ArgumentChecker {
        private final List<Object> arguments;
        private final boolean checkAny;

        private ArgumentChecker(List<Object> arguments, boolean checkAny) {
            this.arguments = arguments;
            this.checkAny = checkAny;
        }

        static ArgumentChecker checkAll(List<Object> arguments) {
            return new ArgumentChecker(arguments, false);
        }

        static ArgumentChecker checkAny(List<Object> arguments) {
            return new ArgumentChecker(arguments, true);
        }

        static ArgumentChecker check(Object argument) {
            return new ArgumentChecker(Collections.singletonList(argument), true);
        }

        public void matches(String[] matches) {
            Predicate<Object> check = argument -> Arrays.stream(matches).anyMatch(argument.toString()::matches);
            if (this.checkAny) {
                this.matchAny(check);
            } else {
                this.matchAll(check);
            }
        }

        private void matchAll(Predicate<Object> check) {
            if (this.arguments.stream().allMatch(check)) {
                throw new TestAbortedException("All arguments matched one or more regular expression(s) from the `matches` array.");
            }
        }

        private void matchAny(Predicate<Object> check) {
            if (this.arguments.stream().anyMatch(check)) {
                throw new TestAbortedException("One or more arguments matched a regular expression from the `matches` array.");
            }
        }

        public void contains(String[] contains) {
            Predicate<Object> check = argument -> Arrays.stream(contains).anyMatch(argument.toString()::contains);
            if (this.checkAny) {
                this.containsAny(check);
            } else {
                this.containsAll(check);
            }
        }

        private void containsAll(Predicate<Object> check) {
            if (this.arguments.stream().allMatch(check)) {
                throw new TestAbortedException("All arguments contained one or more value(s) from the `contains` array.");
            }
        }

        private void containsAny(Predicate<Object> check) {
            if (this.arguments.stream().anyMatch(check)) {
                throw new TestAbortedException("One or more arguments contained a value from the `contains` array.");
            }
        }
    }
}

