/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.issue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junitpioneer.jupiter.IssueProcessor;
import org.junitpioneer.jupiter.IssueTestSuite;
import org.junitpioneer.jupiter.issue.IssueTestCaseBuilder;

public class IssueExtensionExecutionListener
implements TestExecutionListener {
    public static final String REPORT_ENTRY_KEY = "IssueExtension";
    private final boolean active = ServiceLoader.load(IssueProcessor.class).iterator().hasNext();
    private final ConcurrentMap<String, IssueTestCaseBuilder> testCases = new ConcurrentHashMap<String, IssueTestCaseBuilder>();

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        if (!this.active) {
            return;
        }
        String testId = testIdentifier.getUniqueId();
        Map messages = entry.getKeyValuePairs();
        if (messages.containsKey(REPORT_ENTRY_KEY)) {
            String issueId = (String)messages.get(REPORT_ENTRY_KEY);
            this.testCases.put(testId, new IssueTestCaseBuilder(testId).setIssueId(issueId));
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        String testId;
        if (!this.active) {
            return;
        }
        if (testIdentifier.isTest() && this.testCases.containsKey(testId = testIdentifier.getUniqueId())) {
            TestExecutionResult.Status result = testExecutionResult.getStatus();
            ((IssueTestCaseBuilder)this.testCases.get(testId)).setResult(result);
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (!this.active) {
            return;
        }
        List<IssueTestSuite> issueTestSuites = this.createIssueTestSuites();
        for (IssueProcessor issueProcessor : ServiceLoader.load(IssueProcessor.class)) {
            issueProcessor.processTestResults(issueTestSuites);
        }
    }

    List<IssueTestSuite> createIssueTestSuites() {
        List suites = this.testCases.values().stream().collect(Collectors.toMap(IssueTestCaseBuilder::getIssueId, builder -> new ArrayList<IssueTestCaseBuilder>(Arrays.asList(builder)), (builders1, builders2) -> {
            builders1.addAll(builders2);
            return builders1;
        })).entrySet().stream().map(issueIdWithTestCases -> new IssueTestSuite((String)issueIdWithTestCases.getKey(), ((ArrayList)issueIdWithTestCases.getValue()).stream().map(IssueTestCaseBuilder::build).collect(Collectors.toList()))).collect(Collectors.toList());
        return Collections.unmodifiableList(suites);
    }
}

