/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.cartesian;

import java.lang.reflect.Array;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.PreconditionViolationException;
import org.junitpioneer.jupiter.cartesian.CartesianParameterArgumentsProvider;
import org.junitpioneer.jupiter.cartesian.CartesianTest;

class CartesianValueArgumentsProvider
implements CartesianParameterArgumentsProvider<Object>,
AnnotationConsumer<CartesianTest.Values> {
    private Object[] arguments;

    CartesianValueArgumentsProvider() {
    }

    public void accept(CartesianTest.Values source) {
        List arrays = Stream.of(source.shorts(), source.bytes(), source.ints(), source.longs(), source.floats(), source.doubles(), source.chars(), source.booleans(), source.strings(), source.classes()).filter(array -> Array.getLength(array) > 0).collect(Collectors.toList());
        if (arrays.size() != 1) {
            throw new PreconditionViolationException("Exactly one type of input must be provided in the @" + CartesianTest.Values.class.getSimpleName() + " annotation, but there were " + arrays.size());
        }
        Object originalArray = arrays.get(0);
        this.arguments = IntStream.range(0, Array.getLength(originalArray)).mapToObj(index -> Array.get(originalArray, index)).toArray();
    }

    @Override
    public Stream<Object> provideArguments(ExtensionContext context, Parameter parameter) {
        return Arrays.stream(this.arguments);
    }
}

