/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.cartesian;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.internal.PioneerUtils;
import org.junitpioneer.internal.TestNameFormatter;
import org.junitpioneer.jupiter.cartesian.CartesianArgumentsProvider;
import org.junitpioneer.jupiter.cartesian.CartesianArgumentsSource;
import org.junitpioneer.jupiter.cartesian.CartesianMethodArgumentsProvider;
import org.junitpioneer.jupiter.cartesian.CartesianParameterArgumentsProvider;
import org.junitpioneer.jupiter.cartesian.CartesianTest;
import org.junitpioneer.jupiter.cartesian.CartesianTestInvocationContext;

class CartesianTestExtension
implements TestTemplateInvocationContextProvider {
    CartesianTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), CartesianTest.class).isPresent();
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        List<List<?>> sets = this.computeSets(context);
        TestNameFormatter formatter = this.createNameFormatter(context);
        return PioneerUtils.cartesianProduct(sets).stream().map(params -> new CartesianTestInvocationContext((List<?>)params, formatter));
    }

    private TestNameFormatter createNameFormatter(ExtensionContext context) {
        CartesianTest annotation = (CartesianTest)AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), CartesianTest.class).orElseThrow(() -> new ExtensionConfigurationException("@CartesianTest not found."));
        String pattern = annotation.name();
        if (pattern.isEmpty()) {
            throw new ExtensionConfigurationException("CartesianTest can not have an empty display name.");
        }
        String displayName = context.getDisplayName();
        return new TestNameFormatter(pattern, displayName, CartesianTest.class);
    }

    private List<List<?>> computeSets(ExtensionContext context) {
        Method testMethod = context.getRequiredTestMethod();
        List<Annotation> methodArgumentsSources = PioneerAnnotationUtils.findMethodArgumentsSources(testMethod);
        List<? extends Annotation> parameterArgumentsSources = PioneerAnnotationUtils.findParameterArgumentsSources(testMethod);
        CartesianTestExtension.ensureNoInputConflicts(methodArgumentsSources, parameterArgumentsSources, testMethod);
        if (!methodArgumentsSources.isEmpty()) {
            return this.getSetsFromMethodArgumentsSource(methodArgumentsSources.get(0), context);
        }
        return this.getSetsFromArgumentsSources(parameterArgumentsSources, context);
    }

    private static void ensureNoInputConflicts(List<?> methodSources, List<?> parameterSources, Method testMethod) {
        if (methodSources.isEmpty() && parameterSources.isEmpty() && testMethod.getParameters().length > 0) {
            throw new ExtensionConfigurationException("No arguments sources were found for @CartesianTest");
        }
        if (!methodSources.isEmpty() && !parameterSources.isEmpty()) {
            throw new ExtensionConfigurationException("Providing both method-level and parameter-level argument sources for @CartesianTest is not supported.");
        }
        if (methodSources.size() > 1) {
            throw new ExtensionConfigurationException("Only one method-level arguments source can be used with @CartesianTest");
        }
    }

    private List<List<?>> getSetsFromMethodArgumentsSource(Annotation argumentsSource, ExtensionContext context) {
        try {
            CartesianMethodArgumentsProvider provider = this.initializeMethodArgumentsProvider(argumentsSource, context.getRequiredTestMethod());
            return provider.provideArguments(context).getArguments();
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Could not provide arguments because of exception.", (Throwable)ex);
        }
    }

    private List<List<?>> getSetsFromArgumentsSources(List<? extends Annotation> argumentsSources, ExtensionContext context) {
        ArrayList sets = new ArrayList();
        List<Parameter> parameters = Arrays.asList(context.getRequiredTestMethod().getParameters());
        for (int i = 0; i < Math.min(parameters.size(), argumentsSources.size()); ++i) {
            sets.add(this.getSetFromAnnotation(context, argumentsSources.get(i), parameters.get(i)));
        }
        return sets;
    }

    private List<?> getSetFromAnnotation(ExtensionContext context, Annotation source, Parameter parameter) {
        try {
            CartesianParameterArgumentsProvider<?> provider = this.initializeParameterArgumentsProvider(source, parameter);
            return this.provideArguments(context, parameter, provider);
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Could not provide arguments because of exception.", (Throwable)ex);
        }
    }

    private CartesianMethodArgumentsProvider initializeMethodArgumentsProvider(Annotation source, Method method) {
        CartesianArgumentsSource providerAnnotation = (CartesianArgumentsSource)AnnotationSupport.findAnnotation((AnnotatedElement)method, CartesianArgumentsSource.class).orElseThrow(() -> new IllegalStateException(String.format("%s was not annotated with @CartesianArgumentsSource or @ArgumentsSource but should have been.", source.annotationType())));
        CartesianArgumentsProvider provider = (CartesianArgumentsProvider)ReflectionSupport.newInstance(providerAnnotation.value(), (Object[])new Object[0]);
        if (!(provider instanceof CartesianMethodArgumentsProvider)) {
            throw new PreconditionViolationException(String.format("%s does not implement %s interface.", provider.getClass(), CartesianMethodArgumentsProvider.class.getSimpleName()));
        }
        return (CartesianMethodArgumentsProvider)AnnotationConsumerInitializer.initialize((AnnotatedElement)method, (Object)((CartesianMethodArgumentsProvider)provider));
    }

    private CartesianParameterArgumentsProvider<?> initializeParameterArgumentsProvider(Annotation source, Parameter parameter) {
        Class providerClass;
        Optional cartesianProviderAnnotation = AnnotationSupport.findAnnotation((AnnotatedElement)parameter, CartesianArgumentsSource.class);
        if (cartesianProviderAnnotation.isPresent()) {
            providerClass = ((CartesianArgumentsSource)cartesianProviderAnnotation.get()).value();
        } else {
            ArgumentsSource providerAnnotation = (ArgumentsSource)AnnotationSupport.findAnnotation((AnnotatedElement)parameter, ArgumentsSource.class).orElseThrow(() -> new IllegalStateException(String.format("%s was not annotated with %s or %s but should have been.", source.annotationType(), CartesianArgumentsSource.class.getName(), ArgumentsSource.class.getName())));
            providerClass = providerAnnotation.value();
        }
        return CartesianTestExtension.getAndInitializeCartesianParameterArgumentsProvider(providerClass, parameter);
    }

    private static <T> CartesianParameterArgumentsProvider<?> getAndInitializeCartesianParameterArgumentsProvider(Class<T> providerClass, Parameter parameter) {
        Object provider = AnnotationConsumerInitializer.initialize((AnnotatedElement)parameter, (Object)ReflectionSupport.newInstance(providerClass, (Object[])new Object[0]));
        if (!(provider instanceof CartesianParameterArgumentsProvider)) {
            throw new PreconditionViolationException(String.format("%s does not implement %s interface.", provider.getClass(), CartesianParameterArgumentsProvider.class.getSimpleName()));
        }
        return (CartesianParameterArgumentsProvider)provider;
    }

    private List<?> provideArguments(ExtensionContext context, Parameter source, CartesianParameterArgumentsProvider<?> provider) throws Exception {
        return provider.provideArguments(context, source).distinct().collect(Collectors.toList());
    }
}

