/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.cartesian;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.platform.commons.PreconditionViolationException;
import org.junitpioneer.jupiter.cartesian.CartesianArgumentsSource;
import org.junitpioneer.jupiter.cartesian.CartesianEnumArgumentsProvider;
import org.junitpioneer.jupiter.cartesian.CartesianFactoryArgumentsProvider;
import org.junitpioneer.jupiter.cartesian.CartesianTestExtension;
import org.junitpioneer.jupiter.cartesian.CartesianValueArgumentsProvider;

@TestTemplate
@ExtendWith(value={CartesianTestExtension.class})
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface CartesianTest {
    public static final String DISPLAY_NAME_PLACEHOLDER = "{displayName}";
    public static final String INDEX_PLACEHOLDER = "{index}";
    public static final String ARGUMENTS_PLACEHOLDER = "{arguments}";

    public String name() default "[{index}] {arguments}";

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.ANNOTATION_TYPE})
    @CartesianArgumentsSource(value=CartesianFactoryArgumentsProvider.class)
    public static @interface MethodFactory {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @CartesianArgumentsSource(value=CartesianEnumArgumentsProvider.class)
    public static @interface Enum {
        public Class<? extends java.lang.Enum<?>> value() default CartesianEnumArgumentsProvider.NullEnum.class;

        public String[] names() default {};

        public Mode mode() default Mode.INCLUDE;

        public static enum Mode {
            INCLUDE(Mode::validateNames, (name, names) -> names.contains(name)),
            EXCLUDE(Mode::validateNames, (name, names) -> !names.contains(name)),
            MATCH_ALL(Mode::validatePatterns, (name, patterns) -> patterns.stream().allMatch(name::matches)),
            MATCH_ANY(Mode::validatePatterns, (name, patterns) -> patterns.stream().anyMatch(name::matches));

            private final Validator validator;
            private final BiPredicate<String, Set<String>> selector;

            private Mode(Validator validator, BiPredicate<String, Set<String>> selector) {
                this.validator = validator;
                this.selector = selector;
            }

            void validate(Enum enumSource, Set<? extends java.lang.Enum<?>> constants, Set<String> names) {
                this.validator.validate(Objects.requireNonNull(enumSource), constants, Objects.requireNonNull(names));
            }

            boolean select(java.lang.Enum<?> constant, Set<String> names) {
                return this.selector.test(Objects.requireNonNull(constant.name()), Objects.requireNonNull(names));
            }

            private static void validateNames(Enum enumSource, Set<? extends java.lang.Enum<?>> constants, Set<String> names) {
                Set allNames = constants.stream().map(java.lang.Enum::name).collect(Collectors.toSet());
                if (!allNames.containsAll(names)) {
                    throw new PreconditionViolationException("Invalid enum constant name(s) in " + enumSource + ". Valid names include: " + allNames);
                }
            }

            private static void validatePatterns(Enum enumSource, Set<? extends java.lang.Enum<?>> constants, Set<String> names) {
                try {
                    names.forEach(Pattern::compile);
                }
                catch (PatternSyntaxException e) {
                    throw new PreconditionViolationException("Pattern compilation failed for a regular expression supplied in " + enumSource, (Throwable)e);
                }
            }

            private static interface Validator {
                public void validate(Enum var1, Set<? extends java.lang.Enum<?>> var2, Set<String> var3);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @CartesianArgumentsSource(value=CartesianValueArgumentsProvider.class)
    public static @interface Values {
        public short[] shorts() default {};

        public byte[] bytes() default {};

        public int[] ints() default {};

        public long[] longs() default {};

        public float[] floats() default {};

        public double[] doubles() default {};

        public char[] chars() default {};

        public boolean[] booleans() default {};

        public String[] strings() default {};

        public Class<?>[] classes() default {};
    }
}

