/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.cartesian;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junitpioneer.internal.PioneerUtils;
import org.junitpioneer.jupiter.cartesian.ArgumentSets;
import org.junitpioneer.jupiter.cartesian.CartesianMethodArgumentsProvider;
import org.junitpioneer.jupiter.cartesian.CartesianTest;

class CartesianFactoryArgumentsProvider
implements CartesianMethodArgumentsProvider,
AnnotationConsumer<CartesianTest.MethodFactory> {
    private String methodFactoryName;

    CartesianFactoryArgumentsProvider() {
    }

    @Override
    public ArgumentSets provideArguments(ExtensionContext context) throws Exception {
        Method testMethod = context.getRequiredTestMethod();
        Method factory = CartesianFactoryArgumentsProvider.findMethodFactory(testMethod, this.methodFactoryName);
        return this.invokeMethodFactory(testMethod, factory);
    }

    private static Method findMethodFactory(Method testMethod, String methodFactoryName) {
        String factoryName = CartesianFactoryArgumentsProvider.extractMethodFactoryName(methodFactoryName);
        Class<?> declaringClass = CartesianFactoryArgumentsProvider.findExplicitOrImplicitClass(testMethod, methodFactoryName);
        Method factory = PioneerUtils.findMethodCurrentOrEnclosing(declaringClass, factoryName, new Class[0]).orElseThrow(() -> new ExtensionConfigurationException("Method `Stream<? extends Arguments> " + factoryName + "()` not found in " + declaringClass + " or any enclosing class."));
        String method = "Method `" + factory + "`";
        if (!Modifier.isStatic(factory.getModifiers())) {
            throw new ExtensionConfigurationException(method + " must be static.");
        }
        if (!ArgumentSets.class.isAssignableFrom(factory.getReturnType())) {
            throw new ExtensionConfigurationException(String.format("%s must return a `%s` object", method, ArgumentSets.class.getName()));
        }
        return factory;
    }

    private static String extractMethodFactoryName(String methodFactoryName) {
        if (methodFactoryName.contains("(")) {
            methodFactoryName = methodFactoryName.substring(0, methodFactoryName.indexOf(40));
        }
        if (methodFactoryName.contains("#")) {
            return methodFactoryName.substring(methodFactoryName.indexOf(35) + 1);
        }
        return methodFactoryName;
    }

    private static Class<?> findExplicitOrImplicitClass(Method testMethod, String methodFactoryName) {
        if (!methodFactoryName.contains("#")) {
            return testMethod.getDeclaringClass();
        }
        String className = methodFactoryName.substring(0, methodFactoryName.indexOf(35));
        Try tryToLoadClass = ReflectionSupport.tryToLoadClass((String)className);
        for (Class<?> methodClass = testMethod.getDeclaringClass(); methodClass != null; methodClass = methodClass.getEnclosingClass()) {
            String enclosingName = methodClass.getName();
            tryToLoadClass = tryToLoadClass.orElse(() -> ReflectionSupport.tryToLoadClass((String)(enclosingName + "$" + className)));
        }
        return (Class)tryToLoadClass.getOrThrow(ex -> new ExtensionConfigurationException(String.format("Class %s not found, referenced in method %s", className, testMethod.getName()), (Throwable)ex));
    }

    private ArgumentSets invokeMethodFactory(Method testMethod, Method factory) {
        ArgumentSets argumentSets = (ArgumentSets)ReflectionSupport.invokeMethod((Method)factory, null, (Object[])new Object[0]);
        long count = argumentSets.getArguments().size();
        if (count > (long)testMethod.getParameterCount()) {
            throw new ParameterResolutionException(String.format("Method `%s` must register values for each parameter exactly once. Expected [%d] parameter sets, but got [%d].", factory, testMethod.getParameterCount(), count));
        }
        return argumentSets;
    }

    public void accept(CartesianTest.MethodFactory factory) {
        this.methodFactoryName = factory.value();
    }
}

